<?php
/*************************
 * Plugin Name: CarAds WP plugin
 * Description: For dig der vil have en god oplevelse med CarAds
 * Plugin URI: https://carads.io/
 * Version: 2026.01.20082526
 * Requires at least: 6.9
 * Requires PHP: 8.3
 * Elementor tested up to: 3.26.0
 * Elementor Pro tested up to: 3.26.3
 * Requires Yoast SEO: 23.0
 * Author: carads.io
 * Author URI: https://carads.io/
 * Text Domain: carads-nextgen
 *************************/
use CarAdsNextgen\Wordpress\Install;

#ini_set('display_errors', 1);
#ini_set('display_startup_errors', 1);
#error_reporting(E_ALL);
/**
 * Add some helper const's
 */
const CA_NEXTGEN_PATH = __DIR__;
const CA_NEXTGEN_FILE = __FILE__;
const CA_CACHE_PATH = WP_CONTENT_DIR . '/cache/carads-nextgen';
const CA_LOG_PATH = WP_CONTENT_DIR . '/logs/carads-nextgen';
// check if defined

define("CA_NEXTGEN_URL", plugin_dir_url(__FILE__));
define("CA_NEXTGEN_BASE", plugin_basename(__FILE__));
const CA_TEST_PATH = false; 
const CA_TEST = false;
define("CA_TIME", 1768897526);
const CA_NEXTGEN_VERSION = '2026.01.20082526';
const CA_BRANCH = 'develop';
const CA_PHP_VERSION = '8.3';
const CA_WORDPRESS_VERSION = '6.9';
const CA_ELEMENTOR_VERSION = '3.26.0';
const CA_ELEMENTOR_PRO_VERSION = '3.26.3';
const CA_YOAST_SEO_VERSION = '23.0';

defined('ABSPATH') or die('No script kiddies please!');

require_once __DIR__ . '/includes/_register.php';

// check if php version is correct
if (@version_compare(PHP_VERSION, CA_PHP_VERSION, '<')) {
    @add_action('admin_notices', function () {
        echo '<div class="notice notice-error is-dismissible"><p>' . sprintf(__('CarAds Nextgen kræver PHP version %s eller nyere. Din version er %s. Venligst opdater PHP.', 'carads-nextgen'), CA_PHP_VERSION, PHP_VERSION) . '</p></div>';
    });

    return;
}
else if (@version_compare(get_bloginfo('version'), CA_WORDPRESS_VERSION, '<')) {
    @add_action('admin_notices', function () {
        echo '<div class="notice notice-error is-dismissible"><p>' . sprintf(__('CarAds Nextgen kræver WordPress version %s eller nyere. Din version er %s. Venligst opdater WordPress.', 'carads-nextgen'), CA_WORDPRESS_VERSION, get_bloginfo('version')) . '</p></div>';
    });

    return;
}

add_action( 'plugins_loaded', function() {
    include_once ABSPATH . 'wp-includes/pluggable.php';
    return include_once __DIR__ . '/includes/bootstrap.php';
});

register_activation_hook(__FILE__, [Install::class, 'activation']);
register_deactivation_hook(__FILE__, [Install::class, 'deactivation']);
register_uninstall_hook(__FILE__, [Install::class, 'uninstall']);