if(wp?.customize?.controlConstructor === undefined) {
    wp.customize.controlConstructor = {};
}

wp.customize.controlConstructor['carads_color'] = wp?.customize?.Control?.extend({
    ready: function ready() {
        const control = this;

        // Re-render control when setting changes.
        control.setting.bind( () => {
            control.renderContent();
        } );

        control.rgbaControlNotifications();
    },
    embed: function() {
        const control = this;
        const sectionId = control.section();
        if ( ! sectionId ) {
            return;
        }
        wp.customize.section( sectionId, function( section ) {
            section.expanded.bind( function( expanded ) {
                if ( expanded ) {
                    control.actuallyEmbed();
                }
            } );
        } );
    },
    actuallyEmbed: function() {
        const control = this;
        if ( 'resolved' === control.deferred.embedded.state() ) {
            return;
        }
        control.renderContent();
        control.deferred.embedded.resolve(); // Triggers control.ready().
    },
    initialize: function initialize(id, params) {
        const control = this;

        // Bind functions to this control context for passing as React props.
        control.setNotificationContainer = control.setNotificationContainer.bind( control );

        wp.customize.Control.prototype.initialize.call( control, id, params );
        console.log('initialize', control);

        // The following should be eliminated with <https://core.trac.wordpress.org/ticket/31334>.
        function onRemoved( removedControl ) {
            if ( control === removedControl ) {
                control.destroy();
                control.container.remove();
                wp.customize.control.unbind( 'removed', onRemoved );
            }
        }
        wp.customize.control.bind( 'removed', onRemoved );
    },
    setNotificationContainer: function setNotificationContainer(element) {
        const control = this;
        control.notifications.container = jQuery( element );
        control.notifications.render();
    },
    renderContent: function renderContent() {
        const control = this;
        const value = control.setting.get();

        console.log('renderContent', control, value);

        ReactDOM.render(
            '<h1>Test</h1>',
            control.container[0]
        );
        // inline code work too - control.container[0].innerHTML = '<h1>Test</h1>';
    },
    destroy: function destroy() {
        const control = this;

        // Garbage collection: undo mounting that was done in the embed/renderContent method.
        ReactDOM.unmountComponentAtNode( control.container[0] );

        // Call destroy method in parent if it exists (as of #31334).
        if ( wp.customize.Control.prototype.destroy ) {
            wp.customize.Control.prototype.destroy.call( control );
        }
    },
    rgbaControlNotifications: function() {
        const control = this;
        const code = 'long_title';
        const patternTest = RegExp( /^(\#[\da-f]{3}|\#[\da-f]{6}|\#[\da-f]{8}|rgba\(((\d{1,2}|1\d\d|2([0-4]\d|5[0-5]))\s*,\s*){2}((\d{1,2}|1\d\d|2([0-4]\d|5[0-5]))\s*)(,\s*(0\.\d+|1))\)|hsla\(\s*((\d{1,2}|[1-2]\d{2}|3([0-5]\d|60)))\s*,\s*((\d{1,2}|100)\s*%)\s*,\s*((\d{1,2}|100)\s*%)(,\s*(0\.\d+|1))\)|rgb\(((\d{1,2}|1\d\d|2([0-4]\d|5[0-5]))\s*,\s*){2}((\d{1,2}|1\d\d|2([0-4]\d|5[0-5]))\s*)|hsl\(\s*((\d{1,2}|[1-2]\d{2}|3([0-5]\d|60)))\s*,\s*((\d{1,2}|100)\s*%)\s*,\s*((\d{1,2}|100)\s*%)\))$/ );

        // Make sure we have the message before proceeding.
        if ( ! window._wpCustomizeControlsL10n.cheatin ) {
            return;
        }

        wp.customize( control.id, function( setting ) {
            setting.bind( function( value ) {

                if ( false === patternTest.test( value ) ) {
                    setting.notifications.add( code, new wp.customize.Notification( code, {
                        type: 'warning',
                        message: window._wpCustomizeControlsL10n.cheatin
                    } ) );
                } else {
                    setting.notifications.remove( code );
                }
            } );
        } );
    }
});