<?php
/**
 * @copyright  Copyright (C) 2026 CarAds. All rights reserved.
 * @version 2026.01.20082526
 * @author CarAds Team
 */
namespace CarAdsNextgen\Abstracts;
use WP_Customize_Manager;

abstract class Customize
{
    protected string $key = '';

    protected string $section = '';

    abstract protected function settings(WP_Customize_Manager $customize) : mixed;

    abstract protected function control(WP_Customize_Manager $customize) : mixed;

    final public function register(WP_Customize_Manager $customize) : void
    {
        $customize->add_setting($this->key, $this->settings($customize));

        $control = $this->control($customize);

        if(is_array($control))
        {
            $customize->add_control($this->key, $control);
        }
        else
        {
            $customize->add_control($control);
        }
    }

    /**
     * @throws \Exception
     */
    public function __call(string $name, array $arguments)
    {
        // check if variable exists in class
        if (property_exists($this, $name))
        {
            // check type of variable - if array use $arguments as array
            if(is_array($this->{$name}))
            {
                $this->{$name} = $arguments;
            }
            else
            {
                $this->{$name} = $arguments[0];
            }
        }

        return $this;
    }

    public function key(string $key) : self
    {
        $this->key = $key;

        return $this;
    }

    public function section(string|\WP_Customize_Section $section) : self
    {
        $this->section = $section instanceof \WP_Customize_Section ? $section->id : $section;

        return $this;
    }
}