<?php
/**
 * @copyright  Copyright (C) 2026 CarAds. All rights reserved.
 * @version   2026.01.20082526
 * @author    CarAds Team
 */
namespace CarAdsNextgen\Basic;
use Elementor\Widget_Base as ElementorWidgetBase;
class ElementorWidget extends ElementorWidgetBase
{
    protected string $title = 'Shared Elementor Widget';
    protected string $tag = 'elementor';
    protected string $icon = 'eicon-code';
    protected array $category = ['shared-widgets'];
    public function get_name() : string
    {
        return $this->tag;
    }

    public function get_title() : string{
        return $this->title;
    }

    public function get_icon(): string
    {
        return $this->icon;
    }

    public function get_categories() : array{
        return $this->category;
    }

    protected function render() : void{
        echo '<div>Shared Elementor Widget</div>';
    }

    protected function register_controls(){
    }

    /**
     * @param string $title
     * @param string $tag
     * @param string $icon
     * @param array $category
     * @return ElementorWidgetBase
     *
     * Why useing this and not just new class extends ElementorWidget?
     * we have contact shortcode that be extended in other shortcodes. we need
     * change title, tag, icon, category dynamically. this is the only way to do it easy.
     */
    public function createCustomInstance(
        string $title,
        string $tag,
        string $icon,
        array $category
    ): ElementorWidgetBase{
        $this->tag = $tag;
        $this->title = $title;
        $this->icon = $icon;
        $this->category = $category;
        return $this;
    }
}