<?php
/**
 * @copyright  Copyright (C) 2026 CarAds. All rights reserved.
 * @version 2026.01.20082526
 * @author CarAds Team
 */
namespace CarAdsNextgen\Content;

class Cleanup
{
    public static function logs(): void
    {
        $files = glob(CA_LOG_PATH . '/*');

        foreach($files as $file){
            if(is_file($file)){
                @unlink($file);
            }
        }
    }

    public static function cache(): array
    {
        $files = glob(CA_CACHE_PATH . '/*');

        array_map('unlink', array_filter($files, function($file){
            return file_exists($file);
        }));

        return array_filter($files, function($file){
            return file_exists($file);
        });
    }

    public static function html(): void
    {
        if (file_exists(CA_CACHE_PATH)) {
            $files = glob(CA_CACHE_PATH . '*.html');
            foreach ($files as $file) {
                if (is_file($file)) {
                    @unlink($file);
                }
            }
        }
    }
}