<?php
/**
 * @copyright  Copyright (C) 2026 CarAds. All rights reserved.
 * @version 2026.01.20082526
 * @author CarAds Team
 */
namespace CarAdsNextgen\Content;

use stdClass;
use function CarAdsNextgen\Basic\css_inject_helper;

class Enqueue
{
    const int QUICK_SEARCH = 1;
    const int QUICK_SEARCH_2 = 2;
    const int SLIDER = 4;
    const int OPENING_TIMES = 5;
    const int SLOW_SEARCH = 6;
    const int SLIDER_CATALOG = 7;
    const int BANNER = 8;

    const int DEALER_MAP = 11;

    public static function css(int $type): void
    {
        $files = self::addCssFile($type);

        foreach ($files as $basename => $file)
        {
            $basename = 'car-ads-' . $basename;
            wp_enqueue_style($basename, css_inject_helper($file), []);
        }
    }

    static private function addWidgetFile(?string $type) :?array{
        return match ($type){
            'description', 'description2' => [
                'widget-description' => 'widgets/description.css'
            ],
            'info' => [
                'widget-info' => 'widgets/info.css',
            ],
            'infoShort' => [
                'widget-info-short' => 'widgets/info-short.css'
            ],
            'infoSlider' => [
                'widget-info-slider' => 'widgets/info-slider.css'
            ],
            'equipment' => [
                'widget-equipment' => 'widgets/equipment.css'
            ],
            'stage' => [
                'widget-stage' => 'widgets/stage.css'
            ],
            'santander' => [
                'widget-santander' => 'widgets/santander.css'
            ],
            'priceboxes' => [
                'widget-price-boxes' => 'widgets/price_boxes.css'
            ],
            'findleasing' => [
                'widget-find-leasing' => 'widgets/findleasing.css'
            ],
            'elfsight' => [
                'widget-elfsight' => 'widgets/elfsight.css'
            ],
            'autoitevsaving', 'autoitevdata' => [
                'widget-evsavings' => 'widgets/autoit_ev.css'
            ],
            'klimaapi','klimaapi2'  => [
                'widget-klima-api' => 'widgets/klima_api.css'
            ],
            'trustpilot' => [
                'widget-trustpilot' => 'widgets/trustpilot.css'
            ],
            'department' => [
                'widget-department' => 'widgets/department.css'
            ],
            'contact' => [
                'widget-contact' => 'widgets/contact.css'
            ],
            'cars' => [
                'swiper'        => 'swiper.css',
                'widget-cars'   => 'widgets/cars.css',
            ],
            'video' => [
                'widget-video' => 'widgets/video.css'
            ],
            'contentSlider' => [
                'widget-content-slider' => 'widgets/content_slider.css',
                'swiper' => 'swiper.css',
            ],
            'caradsCalculator' => [
                'carads_calculator' => 'widgets/calculator.css'
            ],
            'leasinginfo' => [
                'widget-leasing-info' => 'widgets/leasing_info.css'
            ],
            'nextEngine' => [
                'widget-next-engine' => 'widgets/next_engine.css'
            ],
            'fakeCalculation' => [
                'widget-fake-calculation' => 'widgets/fake_calculation.css'
            ],
            'miniLeasing' => [
                'widget-mini-leasing' => 'widgets/mini_leasing.css'
            ],
            'carShop', 'carShopInline' => [
                'widget-carshop' => 'widgets/car_shop.css',
                'datepicker' => 'datepicker.css',
            ],
            'carboost_economy' => [
                'widget-carboost-economy' => 'widgets/carboost_economy.css'
            ],
            'carboost_exchange' => [
                'widget-carboost-exchange' => 'widgets/carboost_exchange.css'
            ],
            'carboostCalculation' => [
                'widget-carboost-calculation' => 'widgets/carboost_calculation.css'
            ],
            'insurance' => [
                'widget-insurance' => 'widgets/insurance.css'
            ],
            default => []
        };
    }
    static private function addCssFile(int $type) :?array{
        return match ($type) {
            self::QUICK_SEARCH => [
                'quick_search'      => 'quick_search.css'
            ],
            self::QUICK_SEARCH_2 => [
                'quick_search'      => 'quick_search.css',
                'filter_classic'    => 'filter/classic.css',
                'range'             => 'range.css',
                'list'              => 'list.css',
                'swiper'            => 'swiper.css',
            ],
            self::SLOW_SEARCH => [
                'form_filter'       => 'forms/filters.css',
                'filter_classic'    => 'filter/classic.css',
                'filter_deep'       => 'filter/deep.css',
                'filter_sort'       => 'filter/sort.css',
                'list'              => 'list.css',
                'range'             => 'range.css',
            ],
            self::SLIDER => [
                'swiper'           => 'swiper.css',
                'slider'            => 'slider.css',
                'list'              => 'list.css',
            ],
            self::SLIDER_CATALOG => [
                'swiper'           => 'swiper.css',
                'catalog_slider'   => 'catalog/slider.css',
                'catalog_search'   => 'catalog/search.css',
            ],
            self::OPENING_TIMES => [
                'opening-times'     => 'department/opening_times/basic.css',
            ],
            self::BANNER => [
                'banner'            => 'department/banner/basic.css',
            ],
            default => null
        };
    }

    static public function product(?stdClass $settings) : void
    {
        $files = [
            'list'              => 'list.css',
            'car'               => 'car.css',
            'lightbox'          => 'lightbox.css'
        ];
        if(!($settings?->disableFilter ?? false)){
            $files['form_filter']   = 'forms/filters.css';
            $files['range']         = 'range.css';

            if(($settings?->search?->filter_type ?? 1) === 2)
            {
                $files['filter_deep'] = 'filter/deep.css';
            }
            else {
                $files['filter_classic'] = 'filter/classic.css';
            }
        }

        if(!(($settings?->disableSearchBar??false) === true)){
            $files['filter_sort'] = 'filter/sort.css';
        }

        if($settings?->car?->parts ?? false){
            $files['widgets'] = 'widgets/optimize.css';
            foreach (($settings?->car?->parts ?? []) as $index => $part){
                $files = array_merge($files, self::addWidgetFile(($part?->t ?? null)));
            }
        }

        foreach ($files as $basename => $file)
        {
            wp_enqueue_style('car-ads-' . $basename, css_inject_helper($file), []);
        }
    }
}