<?php
/**
 * @copyright  Copyright (C) 2026 CarAds. All rights reserved.
 * @version 2026.01.20082526
 * @author CarAds Team
 */
namespace CarAdsNextgen\Controller;

use CarAdsNextgen\Basic\BasicController;
use CarAdsNextgen\Content\Enqueue;
use CarAdsNextgen\Factory;
use stdClass;
use function CarAdsNextgen\Basic\createAttributes;
use function CarAdsNextgen\Basic\getContent;
use function CarAdsNextgen\Basic\getElementorPageById;
use function CarAdsNextgen\Basic\render;

abstract class BasicProductController extends BasicController
{
    abstract public function render();


    protected function wrap($class, $content, $noIndex = false) : string{
        $attr = [
            'class' => $class . ' !ca-blur-none ca-mb-4',
        ];

        if($noIndex){
            $attr['data-nosnippet'] = '';
        }

        // if class include 'ca-hidden', add 'aria-hidden' attribute
        if(str_contains($class, 'ca-hidden')){
            $attr['aria-hidden'] = 'true';
            $attr['tabindex'] = '-1';
            $attr['role'] = 'presentation';
            $attr['style'] = 'display:none;';
        }

        $attrString = createAttributes($attr);

        return '<div '. $attrString .'>' . $content . '</div>';
    }

    protected function fixSettings(stdClass $config) : stdClass{

        if(Factory::getInstance()->settings->cid !== -1){
            $config->cid = Factory::getInstance()->settings->cid; // overwrite the client id for the config
        }

        if(!Factory::getInstance()->settings->optimize)
        {
            return $config;
        }

        $settings = Factory::getInstance()->settings;

        if ($config?->car?->parts && $settings->form_layout !== 'all'){
            $parts = $config?->car?->parts ?? [];

            if(!empty($parts)) {
                foreach ($parts as $index => $part) {
                    if ($part->t === 'contact') {
                        $config->car->parts[$index]->s->input_layout = $settings->form_layout; // set the form layout
                    }
                }
            }
        }

        return $config;
    }

    protected function page($config, $namespace) : array{
        $before = null;
        $after = null;
        if($config?->top_page ?? null){
            $before = $this->callSearch('intro', $config, (object)['elementor' => $config->top_page->id], $namespace);
            unset($config->top_page);
        }

        if($config?->bottom_page ?? null){
            $after = $this->callSearch('intro_after', $config, (object)['elementor' => $config->bottom_page->id], $namespace);
            unset($config->bottom_page);
        }

        return [$before, $after];
    }

    protected function callSearch($file, stdClass $config, ?stdClass $data, string $namespace) : ?string{
        if(!$data){
            return null;
        }

        if($data?->key ?? null)
        {
            $namespace = $namespace . '-' . sha1("{$data->key}");
        }

        if($data?->elementor ?? null)
        {
            $namespace = $namespace . '-' . sha1("{$data->elementor}");
        }

        if($data?->elementor ?? null)
        {
            $page = getElementorPageById($data->elementor, true);

            if(!empty($page)){
                $content = @getContent($page);
                $data->content = $content->content ?? null;
                $data->css = $content->css ?? null;
            }
            else {
                $data->content = '';
                $data->css = '';
            }
        }

        return render(CA_NEXTGEN_PATH . "/template-parts/search/{$file}_search.php", [
            'config' => $config,
            'data' => $data,
            'namespace' => $namespace,
        ]);
    }

    protected function staticRender(stdClass $config, ?string $before = null, ?string $after = null, ?string $body = null) : void{
        /**
         * Not finished yet - it wht it is commented out for now in the develop branch
         */
        if(Factory::getInstance()->settings->optimize){
            Enqueue::product($config);
        }

        get_header();

        if(is_string($before))
        {
            echo $before;
        }

        echo render(CA_NEXTGEN_PATH . '/template-parts/search/search.php', [
            'config' => $config, 'body' => $body
        ]);

        if(is_string($after))
        {
            echo $after;
        }

        get_footer();
    }
}