<?php
/**
 * @copyright  Copyright (C) 2026 CarAds. All rights reserved.
 * @version 2026.01.20082526
 * @author CarAds Team
 */
namespace CarAdsNextgen\Controller;
use function CarAdsNextgen\factory;

class ProductsDiffController extends BasicProductController
{
    public function render() : void
    {
        $route  = $this->route;
        $config = $this->fixSettings(factory()->configs->get($route->active()->path . '_master'));
        $namespace  = $route->active()->path;

        $this->query->is_404 = false;

        list($before, $after) = $this->page($config, $namespace);

        if($before){
            $before = $this->wrap('carads-intro-top !ca-hidden', $before);
        }

        if($after){
            $after = $this->wrap('carads-intro-bottom !ca-hidden', $after);
        }

        status_header(200, 'OK');

        $this->staticRender(
            $config,
            $before,
            $after
        );
        die;
    }
}