<?php
/**
 * @copyright  Copyright (C) 2026 CarAds. All rights reserved.
 * @version 2026.01.20082526
 * @author CarAds Team
 */
namespace CarAdsNextgen\Controller;

use CarAdsNextgen\Basic\BasicController;
use function CarAdsNextgen\factory;

class SiteMapController extends BasicController
{
    public function render() : void
    {
        $route  = $this->route;
        $config = factory()->configs->get('sitemap');
        $id     = $route->active()->params->id;
        // config for sitemap is list of id. so check if id is in list
        if(!in_array($id, $config)){
            return;
        }

        status_header(200, 'OK');
        header('Content-Type: application/xml');
        echo $this->fetch($id);
        exit;
    }

    public function fetch(int|string|float $id) : string{
        $url = "https://nextgen.carads.io/sitemaps/{$id}/sitemap.xml";

        $data = (new \WP_Http())->get($url);

        return $data['body'] ?? '';
    }
}