<?php
/**
 * @copyright  Copyright (C) 2026 CarAds. All rights reserved.
 * @version 2026.01.20082526
 * @author CarAds Team
 */
namespace CarAdsNextgen\Customize;
use CarAdsNextgen\Abstracts\Customize;
use WP_Customize_Manager;
use WP_Customize_Setting;
/**
 * @method Checkbox label(string $label)
 * @method Checkbox value(int $value)
 * @method Checkbox description(string $description)
 */
class Checkbox extends Customize
{
    protected string $label = '';

    protected int $default = 0;

    protected int $value = 0;
    protected string $section = '';

    protected string $description = '';

    protected function settings(WP_Customize_Manager $customize): array
    {
        return [
            'value'             => $this->value,
            'type'              => 'option',
            'transport'         => 'refresh',
            'theme_supports'    => '',
            'capability'        => 'manage_options',
        ];
    }

    protected function control(WP_Customize_Manager $customize): array
    {
        return [
            'label'   => $this->label,
            'description' => $this->description,
            'section' => $this->section,
            'type' => 'checkbox',
            'settings'   => $this->key
        ];
    }
}