<?php
/**
 * @copyright  Copyright (C) 2026 CarAds. All rights reserved.
 * @version 2026.01.20082526
 * @author CarAds Team
 */
namespace CarAdsNextgen\Customize;

use CarAdsNextgen\Abstracts\Customize;
use CarAdsNextgen\Customize\Control\Color as ColorControl;
use WP_Customize_Manager;

/**
 * @method Text label(string $label)
 * @method Text default(string $default)
 * @method Text placeholder(string $placeholder)
 * @method Text description(string $description)
 */
class Color extends Customize{
    protected string $label = '';
    protected string $default = '';
    protected string $section = '';
    protected string $placeholder = '';
    protected string $description = '';


    protected function settings(WP_Customize_Manager $customize): array
    {
        return [
            'default'           => $this->default,
            'type'              => 'option',
            'transport'         => 'refresh',
            'theme_supports'    => '',
            'capability'        => 'manage_options',
            'sanitize_callback' => 'sanitize_hex_color'
        ];
    }

    protected function control(WP_Customize_Manager $customize): ColorControl
    {
        return new ColorControl(
            $customize,
            $this->key,
            [
                'label'   => $this->label,
                'description' => $this->description,
                'section' => $this->section,
                'settings'   => $this->key
            ]
        );
    }
}