<?php
/**
 * @copyright  Copyright (C) 2026 CarAds. All rights reserved.
 * @version 2026.01.20082526
 * @author CarAds Team
 */
namespace CarAdsNextgen\Customize;
use CarAdsNextgen\Abstracts\Customize;
use WP_Customize_Manager;

/**
 * @method Select key(string $key)
 * @method Select label(string $label)
 * @method Select default(string $default)
 * @method Select description(string $description)
 * @method Select choices(array $choices)
 */
class Select extends Customize
{
    protected string $key = '';
    protected string $label = '';
    protected string $default = '';
    protected string $description = '';
    protected array $choices = [];

    protected function settings(WP_Customize_Manager $customize): array
    {
        return [
            'default'           => $this->default,
            'type'              => 'option',
            'transport'         => 'refresh',
            'capability'        => 'manage_options',
        ];
    }

    protected function control(WP_Customize_Manager $customize): array
    {
        return [
            'label'   => $this->label,
            'description' => $this->description,
            'section' => $this->section,
            'type' => 'select',
            'settings'   => $this->key,
            'choices' => $this->choices
        ];
    }
}