<?php
/**
 * @copyright  Copyright (C) 2026 CarAds. All rights reserved.
 * @version 2026.01.20082526
 * @author CarAds Team
 */
namespace CarAdsNextgen;

use CarAdsNextgen\Basic\DefaultFactory;
use CarAdsNextgen\Settings\Customize as CustomizeSettings;
use CarAdsNextgen\Basic\Singleton;
use CarAdsNextgen\Utils\Configs;
use CarAdsNextgen\Wordpress\Route;

/**
 * Class Factory
 * @property-read CustomizeSettings $settings
 * @property-read bool $is_test_ip
 * @property-read Configs $configs
 * @property-read Route $route
 */
class Factory extends DefaultFactory
{
    use Singleton;
    private ?Configs $configs = null;

    private function isTestIp(): bool
    {
        $ip_tested = null;

        if($ip_tested !== null){
            return $ip_tested;
        }

        $ips        = $this->settings->test_ip;
        $ip_tested  = false;

        if($ips !== '' && strlen($ips) > 0){
            $ips = explode(',', $ips);
            $ips = array_map('trim', $ips);
            $ip_tested = in_array($_SERVER['REMOTE_ADDR'], $ips);
        }

        return $ip_tested;
    }

    private function settings(){
        static $settings;
        if($settings === null){
            $settings = new CustomizeSettings();
        }

        return $settings;
    }

    private function configs(): Configs
    {
        return $this->configs ?? ($this->configs = new Configs(
            CA_TEST_PATH ? (CA_NEXTGEN_PATH . '/config') : (CA_NEXTGEN_PATH . '/../.c2/')
        ));
    }

    private function route(): Route{
        return Route::getInstance();
    }

    public function __get(string $name): mixed
    {
        return match ($name) {
            'settings' => $this->settings(),
            'is_test_ip' => $this->isTestIp(),
            'configs' => $this->configs(),
            'route' => $this->route(),
            default => parent::__get($name),
        };
    }
}