<?php
/**
 * @copyright  Copyright (C) 2026 CarAds. All rights reserved.
 * @version 2026.01.20082526
 * @author CarAds Team
 */
namespace CarAdsNextgen\RestApi;
use CarAdsNextgen\Basic\RestApi;
use function CarAdsNextgen\factory;

class FindConfig extends RestApi
{
    protected string $route = 'config';
    public function run(\WP_REST_Request $request) : array
    {
        $find = $_GET['find'] ?? '';
        if(empty($find)){
            return ['message' => 'invalid.find'];
        }

        return factory()->configs->exists($find . '_master') ?
            (array)factory()->configs->get($find . '_master') :
            ['message' => 'not.found'];
    }
}