<?php
/**
 * @copyright  Copyright (C) 2026 CarAds. All rights reserved.
 * @version 2026.01.20082526
 * @author CarAds Team
 */
namespace CarAdsNextgen\RestApi;

use CarAdsNextgen\Basic\RestApi;
use WP_REST_Request;
use function CarAdsNextgen\cacheDate;
use function CarAdsNextgen\Basic\_domDocument;
use function CarAdsNextgen\Basic\getElementorPageById;
use function CarAdsNextgen\factory;

class LoadPage extends RestApi
{
    protected string $route = 'load-page';
    public function run(WP_REST_Request $request) : array
    {
        $this->headers();


        $feed = (string) $request->get_param('feed');
        $page = (int) $request->get_param('page');

        // load config and check if feed will allow to load page
        $config = factory()->configs->getRaw($feed . '_master');

        if (empty($config))
        {
            return ['message' => 'invalid.request'];
        }

        $config = json_decode($config);

        $checkExists = ['top_page', 'bottom_page', 'no_results_page'];
        $validate = false;

        foreach ($checkExists as $check)
        {
            if (
                isset($config->{$check}) &&
                ((int) $config->{$check}->id) === $page &&
                $config->{$check}->type === 'elementor'
            )
            {
                $validate = true;
                break;
            }
        }

        if (!$validate)
        {
            return ['message' => 'invalid.page'];
        }

        // check if we have cache version of this page
        $data = cacheDate('ca_' . $feed . '_page_' . $page);

        if ($data)
        {
            return ['data' => $data];
        }

        $content = getElementorPageById($page, true);
        $dom = _domDocument($content);
        $xpath = new \DOMXPath($dom);
        $divs = $xpath->query('//div[@data-elementor-type="wp-page"]');
        $divs->item(0)
            ->setAttribute('style', 'min-height: auto;');

        $styleTag = $xpath->query('//style');
        $css = $styleTag->item(0)->textContent;

        $modifiedHtml = $dom->saveHTML($divs->item(0));
        $modifiedHtml = str_replace("\n", '', $modifiedHtml);
        $modifiedHtml = str_replace("\t", '', $modifiedHtml);

        $data = [
            'content' => $modifiedHtml,
            'raw' => $css,
            'time' => time()
        ];

        cacheDate('ca_' . $feed . '_page_' . $page, $data);

        return $data;
    }
}