<?php
/**
 * @copyright  Copyright (C) 2026 CarAds. All rights reserved.
 * @version 2026.01.20082526
 * @author CarAds Team
 */
namespace CarAdsNextgen\RestApi;

use CarAdsNextgen\Basic\RestApi;
use CarAdsNextgen\Factory;
use WP_REST_Request;
use function CarAdsNextgen\Basic\isValidUuidV4;

class Ping extends RestApi
{
    protected string $route = 'ping';
    public function run(WP_REST_Request $request) : array
    {
        $this->headers();
        $params = $request->get_params();

        // check if key is valid
        $key            = $params['key'] ?? null;

        $ca_secure_key  = Factory::getInstance()->settings->secure_key ?? '';

        if (!isValidUuidV4($ca_secure_key) || !isValidUuidV4($key) || $key !== $ca_secure_key) {
            return ['message' => 'invalid.sp-key'];
        }

        return ['time' => time(), 'date' => date('Y-m-d H:i:s'), 'status' => 'ok'];
    }

    public function arguments() : array{
        return [
            'args' => [
                'key' => [
                    'required' => true,
                    'type' => 'string',
                ]
            ]
        ];
    }
}