<?php
/**
 * @copyright  Copyright (C) 2026 CarAds. All rights reserved.
 * @version 2026.01.20082526
 * @author CarAds Team
 */
namespace CarAdsNextgen\RestApi;

use CarAdsNextgen\Basic\RestApi;
use CarAdsNextgen\Factory;
use WP_REST_Request;

class Settings extends RestApi
{
    protected string $route = 'settings';

    public function run(WP_REST_Request $request): array
    {
        global $wpdb;
        $this->headers();
        // check if the security key is valid

        $secureKey = $_GET['secure_key'] ?? null;
        // generate secure key for api - data is not private and can be shared with
        // public but for bots protection we have uniq query that shared for app websites for now
        $caSecureKey = Factory::getInstance()->settings->api_key;

        if ($caSecureKey !== $secureKey) {
            return ['...' => '...'];
        }

        return [
            'carads' => Factory::getInstance()->settings,
            'plugins' => [
                'elementor' => \CarAdsNextgen\Basic\is_plugin_active('elementor/elementor.php'),
                'elementor_pro' => \CarAdsNextgen\Basic\is_plugin_active('elementor-pro/elementor-pro.php'),
                'yoast_seo' => \CarAdsNextgen\Basic\is_plugin_active('wordpress-seo/wp-seo.php'),
                'yoast_seo_pro' => \CarAdsNextgen\Basic\is_plugin_active('wordpress-seo-premium/wp-seo-premium.php'),
                'wp-optimize-premium' => \CarAdsNextgen\Basic\is_plugin_active('wp-optimize-premium/wp-optimize-premium.php'),
                'wp_optimize' => \CarAdsNextgen\Basic\is_plugin_active('wp-optimize/wp-optimize.php'),
                'wp-mail-smtp'  => \CarAdsNextgen\Basic\is_plugin_active('wp-mail-smtp/wp_mail_smtp.php'),
                'updraftplus' => \CarAdsNextgen\Basic\is_plugin_active('updraftplus/updraftplus.php'),
            ],
            'php' => [
                'memory_limit' => ini_get('memory_limit'),
                'max_execution_time' => ini_get('max_execution_time'),
                'upload_max_filesize' => ini_get('upload_max_filesize'),
                'post_max_size' => ini_get('post_max_size'),
                'max_input_vars' => ini_get('max_input_vars'),
                'version' => phpversion()
            ],
            // 'pp' => wp_load_alloptions(),
        ];
    }
}