<?php
/**
 * @copyright  Copyright (C) 2026 CarAds. All rights reserved.
 * @version 2026.01.20082526
 * @author CarAds Team
 */
namespace CarAdsNextgen\RestApi;
use CarAdsNextgen\Basic\RestApi;
use CarAdsNextgen\Basic\UpdateConfig as BasicUpdateConfig;
use \WP_REST_Request;
use function CarAdsNextgen\Basic\current_factory;
use function CarAdsNextgen\Basic\isValidUuidV4;

class UpdateConfig extends RestApi
{
    protected string $route = 'update-config';
    protected string $method = 'POST';
    public function run(WP_REST_Request $request) : array
    {
        $this->headers();
        $secureKey      = (string) $_POST['secure_key'] ?? '';
        $caSecureKey    = (string) current_factory()->settings->api_key ?? '';

        if (!isValidUuidV4($secureKey) || !isValidUuidV4($caSecureKey) || $caSecureKey !== $secureKey) {
            return ['message' => 'invalid.key'];
        }

        $cid        = current_factory()->settings->cid;
        $response   = BasicUpdateConfig::sync($cid);
        $status     = BasicUpdateConfig::errorCodeMessages($response->status);

        return [
            'status' => $status
        ];
    }
}