<?php
/**
 * @copyright  Copyright (C) 2026 CarAds. All rights reserved.
 * @version 2026.01.20082526
 * @author CarAds Team
 */
namespace CarAdsNextgen\Settings;
use CarAdsNextgen\Basic\BasicSettings;

/**
 * Class Customize 🚀🚀🚀
 *
 * @package CarAdsNextgen\Settings
 *
 * @property-read int $cid (-1) = none
 * @property-read bool $shadow_root
 * @property-read bool $cache
 * @property-read bool $optimize
 * @property-read string $form_layout
 * @property-read string $script
 * @property-read bool $remove_all_seo_tags_from_3rd_party
 * // new added property
 * @property-read string $test_ip
 * @property-read bool $carlead_enabled
 * @property-read bool $beta_channel
 * @property-read string $api_key
 * @property-read string $secure_key
 *
 * @property-read bool $cache_only_carads @deprecated
 * @property-read bool $pre_cache @deprecated
 * @property-read bool $fast_render @deprecated
 * @property-read int $cache_time_product @deprecated
 * @property-read int $cache_time_products @deprecated
 * @property-read int $cache_time_home @deprecated
 * @property-read int $cache_time_dealer @deprecated
 * @property-read int $cache_time_dealers @deprecated
 * @property-read bool $allow_3rd_party_login @deprecated
 */
class Customize extends BasicSettings
{
    protected array $settings = [
        'cid' => ['CarAdsNextgenClientID', -1, 'int', 1], // old ca_company_id
        'cache' => ['CarAdsNextgenCache', true, 'bool', 1],
        'script' => ['CarAdsNextgenScript', 'master', 'string', 1],
        'remove_all_seo_tags_from_3rd_party' => ['CarAdsNextgenRemoveAllSeoTagsFrom3rdParty', false, 'bool', 1],
        'test_ip' => ['CarAdsNextgenTestIP', '', 'string', 1],
        'carlead_enabled' => ['CarAdsNextgenCarLeadTracking', false, 'bool', 1],
        'beta_channel' => ['CarAdsNextgenBetaChannel', false, 'bool', 0],
        'optimize' => ['CarAdsNextgenOptimize', false, 'bool', 1],
        'form_layout' => ['CarAdsNextgenFormLayout', 'floating', 'string', 1],
        'shadow_root' => ['CarAdsNextgenShadowRoot', true, 'bool', 1],
        'api_key' => ['CarAdsNextgenApiKey', '', 'string', 1],
        'secure_key' => ['CarAdsNextgenSecureKey', '', 'string', 1], // old ca_secure_key
    ];

    public function remove(): void
    {
        parent::cleanup();
    }

    public function jsonSerialize(): array
    {
        return [];
    }
}