<?php
/**
 * @copyright  Copyright (C) 2026 CarAds. All rights reserved.
 * @version 2026.01.20082526
 * @author CarAds Team
 */
namespace CarAdsNextgen\Shortcode;

use CarAdsNextgen\Basic\ElementorWidget;
use CarAdsNextgen\Basic\Shortcode;
use CarAdsNextgen\Content\Enqueue;
use CarAdsNextgen\Factory;

class Banner extends Shortcode
{
    protected string $tag = 'carads-banner';

    public function render($args = [], $content = null): string
    {
        $config = new \stdClass;

        if ($content !== null) {
            $config = @json_decode(trim($content));
        }

        if (json_last_error() !== JSON_ERROR_NONE) {
            return 'You need add config to shortcode';
        }

        $cache = is_user_logged_in();
        $config->disable_cache = $cache;

        if (Factory::getInstance()->settings->cid !== -1) {
            $config->cid = Factory::getInstance()->settings->cid;
        }

        return $this->inlineHtml(json_encode($config));
    }

    public function enqueue(): void
    {
        Enqueue::css(Enqueue::BANNER);
    }

    private function inlineHtml(string $config): string
    {
        return <<<HTML
        <div class="carads">
            <div class="carads-banner" data-settings='{$config}'>
                henter banner...
            </div>
        </div>
HTML;
    }

    private function fetch(){

    }

    public function elementor_register(): void{
        add_action('elementor/widgets/widgets_registered', function($widgets_manager){
            $widgets_manager->register(new class extends ElementorWidget{
                protected string $title = 'CarAds Banner';
                protected string $icon = 'eicon-banner';
                protected string $tag = 'carads-banner';
                protected array $category = ['carads-widgets'];

                protected function render(): void{
                    $settings = $this->get_settings_for_display();
                    $config = '{}';

                    if (!empty($settings['config'])) {
                        $config = $settings['config'];
                    }

                    echo do_shortcode('[carads-banner]' . $config . '[/carads-banner]');
                }
                protected function register_controls() : void
                {
                    $this->start_controls_section(
                        'section_content',
                        [
                            'label' => __('Content', 'carads-nextgen'),
                        ]
                    );

                    $this->add_control(
                        'config',
                        [
                            'label' => __('Config (JSON)', 'carads-nextgen'),
                            'type' => \Elementor\Controls_Manager::TEXTAREA,
                            'default' => '{}',
                            'placeholder' => __('Enter your JSON config here', 'carads-nextgen'),
                        ]
                    );

                    $this->end_controls_section();
                }
            });
        });
    }
}
