<?php
/**
 * @copyright  Copyright (C) 2026 CarAds. All rights reserved.
 * @version 2026.01.20082526
 * @author CarAds Team
 */
namespace CarAdsNextgen\Shortcode;
use CarAdsNextgen\Basic\ElementorWidget;
use CarAdsNextgen\Basic\Shortcode;
use CarAdsNextgen\Content\Enqueue;
use CarAdsNextgen\Factory;
use stdClass;
use function CarAdsNextgen\Basic\createAttributes;
use function CarAdsNextgen\Basic\fetch_pre_rendered;
use function CarAdsNextgen\factory;

/**
 * Class QuickSearch
 */
class Search extends Shortcode
{
	/**
	 * @var string
	 */
	protected string $tag = 'car-ads-quick-search';
    protected int $enqueue_hook = self::ENQUEUE_METHOD_FULL_CONTROL;
    static protected string $mode = 'single';

    protected ?stdClass $config = null;

	public function render($args = []) : string
	{
        $id = $args['id'] ?? null;
        $pre_render = $args['pre_render'] ?? true;

        if (!$id)
        {
            return 'You need add id to shortcode';
        }

        if (!factory()->configs->exists($id . '_quick'))
        {
            return 'no config found...';
        }

        $settings = factory()->configs->get($id . '_quick');

        $settings->render_mode = self::$mode;


        if(Factory::getInstance()->settings->cid !== -1){
            $settings->cid = Factory::getInstance()->settings->cid; // overwrite the client id for the config
        }

        $config = json_encode($settings); // for minify the config
        $body = '';

        if($pre_render === true && ($settings?->use_search ?? false) === false){
            $body = $this->request($settings->cid, $id);
        }

        return $this->innerHTML(
            settings: $settings,
            config: $config,
            id: $id,
            body: $body
        );
	}

    public function enqueue(stdClass $data):void{
        if(Factory::getInstance()->settings->optimize){
            foreach(array_keys($data->list) as $key){
                if(!factory()->configs->exists($key . '_quick')){
                    continue;
                }

                $settings = factory()->configs->get($key . '_quick');

                if(($settings?->use_search ?? false) === true){
                    Enqueue::css(Enqueue::QUICK_SEARCH_2);
                }
                else {
                    Enqueue::css(Enqueue::QUICK_SEARCH);
                }
            }
        }

        self::$mode = ($data?->count ?? 0) > 1 ? 'multiple' : 'single';
    }

    private function request(int $cid, string $name) : string{
        return fetch_pre_rendered('https://ssr.js.nextgen.carads.io/quick-search/' . $cid . '/' . $name);
    }

    private function innerHTML(stdClass $settings, string $config, string|int $id, string $body) : string{
        $attrParams = [
            'data-settings' => $config,
            'data-version' => '2'
        ];

        if($settings->render_mode === 'single'){
            $attrParams['id'] = 'quick_search';
        }
        else{
            $attrParams['class'] = 'cc_quick_search';
        }


        $attr = createAttributes($attrParams);
        $time = CA_TIME;

        return <<<HTML
        <div class="carads-wrapper" data-time="{$time}">
            <div {$attr}>
                {$body}
            </div>
        </div>
HTML;
    }

    public function elementor_register(): void
    {
        add_action('elementor/widgets/register', function($widgets_manager) {
            $widgets_manager->register(new class extends ElementorWidget {
                protected string $title = 'CarAds Quick Search';
                protected string $tag = 'CarAdsQuickSearch';
                protected string $icon = 'eicon-search';
                protected array $category = ['carads-widgets'];

                protected function register_controls(): void
                {
                    $this->start_controls_section(
                        'section_content',
                        [
                            'label' => __('Content', 'CarAdsNextgen'),
                        ]
                    );

                    $this->add_control(
                        'id',
                        [
                            'label' => __('Quick Search ID', 'CarAdsNextgen'),
                            'type' => \Elementor\Controls_Manager::TEXT,
                            'input_type' => 'text',
                            'placeholder' => __('Enter Quick Search ID', 'CarAdsNextgen'),
                        ]
                    );

                    $this->add_control(
                        'pre_render',
                        [
                            'label' => __('Pre Render', 'CarAdsNextgen'),
                            'type' => \Elementor\Controls_Manager::SELECT,
                            'options' => [
                                'yes' => __('Yes', 'CarAdsNextgen'),
                                'no' => __('No', 'CarAdsNextgen'),
                            ],
                            'default' => 'yes',
                        ]
                    );

                    $this->end_controls_section();
                }

                protected function render(): void
                {
                    $s = $this->get_settings_for_display();
                    $attr = [
                        'id' => $s['id'] ?? '',
                        'pre_render' => $s['pre_render'] === 'yes' ? 1 : 0,
                    ];


                    $attr = createAttributes($attr);

                    echo do_shortcode('[car-ads-quick-search ' . $attr . ']');
                }
            });
        });
    }
}