<?php
/**
 * @copyright  Copyright (C) 2026 CarAds. All rights reserved.
 * @version 2026.01.20082526
 * @author CarAds Team
 */
namespace CarAdsNextgen\Shortcode;
use CarAdsNextgen\Basic\ElementorWidget;
use CarAdsNextgen\Basic\Shortcode;
use CarAdsNextgen\Content\Enqueue;
use function CarAdsNextgen\Basic\createAttributes;
use function CarAdsNextgen\Basic\fetch_pre_rendered;
use function CarAdsNextgen\factory;

/**
 * Class QuickSearch
 */
class Slider extends Shortcode
{
	/**
	 * @var string
	 */
	protected string $tag = 'car-ads-slider';
    private static int $trigger = 0;

	public function render($args = [], $content = null) : string
	{
        $id = $args['id'] ?? null;
        $filter = is_string($content) ? trim($content) : null;
        $url = $args['url'] ?? null;
        $fid = $args['fid'] ?? null;
        $sort = $args['sort'] ?? null;
        $btn = $args['btn'] ?? null;
        $pre_render = $args['pre_render'] ?? true;
        $body = '';

        if (!$id)
        {
            return 'You need add id to shortcode';
        }

        $override = [];

        if (!factory()->configs->exists($id . '_slider'))
        {
            return 'no config found...';
        }

        self::$trigger++;

        $config = json_decode(factory()->configs->getRaw($id . '_slider'));

        if ($filter)
        {
            $config->filter = json_decode($filter);
            $pre_render = false;
            $override['filter'] = $config->filter;
        }

        if ($url)
        {
           $config->url = $url;
           $pre_render = false;
           $override['url'] = $config->url;
        }

        if ($fid)
        {
           $config->fid = $fid;
           $pre_render = false;
              $override['fid'] = $config->fid;
        }

        if($sort){
            $config->sort = $sort;
            $pre_render = false;
            $override['sort'] = $config->sort;
        }

        if ($btn){
            $config->btn = $btn;
            $pre_render = false;
            $override['btn'] = $config->btn;
        }
        
        if(factory()->settings->cid !== -1){
            $config->cid = factory()->settings->cid; // overwrite the client id for the config
            $pre_render = false;
            $override['cid'] = $config->cid;
        }



        // $pre_render is disabled if anythings is changed in settings by shortcode attributes for avoid conflict
        // pre-rendering using other system and has for now not support for override settings by shortcode attributes
        if($pre_render){
            $body = $this->request($config->cid, $id);
        }

        $configString = json_encode($config);

        return $this->innerHtml(
            config: $configString,
            id: $id,
            settings: $config,
            trigger: self::$trigger,
            body: $body,
        );
	}

    public function enqueue() : void{
        if(factory()->settings->optimize){
            Enqueue::css(Enqueue::SLIDER);
        }
    }

    public function request(int $cid, string $name): string
    {
        return fetch_pre_rendered('https://ssr.js.nextgen.carads.io/slider/' . $cid . '/' . $name);
    }

    private function innerHtml(string $config, string $id, object $settings, int $trigger, string $body): string{
        $wrapper = createAttributes(['class' => 'carads', 'data-time' => CA_TIME]);
        $element = createAttributes([
            'class' => 'slider car-slider',
            'data-id' => $id,
            'data-version' => '2',
            'data-ready' => 'false',
            'data-trigger' => $trigger,
            'data-view-port' => (($settings?->view_port ?? false) ? 'true' : 'false'),
        ]);

        return <<<HTML
            <div class="carads-wrapper">
                <div {$wrapper}>
                    <div {$element}>
                        {$body}
                    </div>
                </div>
            </div>
            <script type="application/json" id="carads_slider_{$id}">
                {$config}
            </script>
HTML;
    }

    public function elementor_register() : void{
        add_action('elementor/widgets/register', function($widgets_manager) {
            $widgets_manager->register(new class extends ElementorWidget{
                protected string $title = 'CarAds Slider';
                protected string $tag = 'CarAdsSlider';
                protected string $icon = 'eicon-search';
                protected array $category = ['carads-widgets'];

                protected function render() : void{
                    $s = $this->get_settings_for_display();
                    $attr = [
                        'id' => $s['id'] ?? '',
                        'url' => $s['url'] ?? '',
                        'fid' => $s['fid'] ?? '',
                        'sort' => $s['sort'] ?? '',
                        'btn' => $s['btn'] ?? '',
                        'pre_render' => $s['pre_render'] === 'yes' ? 1 : 0,
                    ];

                    $attr = array_filter($attr, function($value){
                        return !empty($value);
                    });

                    $attr = createAttributes($attr);

                    $filter = empty($s['filter']) ? null : trim($s['filter']);

                    echo do_shortcode('[car-ads-slider ' . $attr . ']' . $filter . '[/car-ads-slider]');
                }

                protected function register_controls(): void
                {
                    $this->start_controls_section('section_content',[
                        'label' => __('Content', 'CarAdsNextgen'),
                    ]);

                    $this->add_control('id', [
                        'label' => __('Slider ID', 'CarAdsNextgen'),
                        'type' => \Elementor\Controls_Manager::TEXT,
                        'default' => '',
                        'description' => __('Enter the Slider ID to display.', 'CarAdsNextgen')
                    ]);
                    $this->add_control('url',[
                        'label' => __('API URL', 'CarAdsNextgen'),
                        'type' => \Elementor\Controls_Manager::TEXT,
                        'default' => '',
                        'description' => __('Optional: Override the API URL.', 'CarAdsNextgen')
                    ]);
                    $this->add_control('fid',[
                        'label' => __('Filter ID', 'CarAdsNextgen'),
                        'type' => \Elementor\Controls_Manager::TEXT,
                        'default' => '',
                        'description' => __('Optional: Override the Filter ID.', 'CarAdsNextgen')
                    ]);
                    $this->add_control('sort',[
                        'label' => __('Sort', 'CarAdsNextgen'),
                        'type' => \Elementor\Controls_Manager::TEXT,
                        'default' => '',
                        'description' => __('Optional: Sorting options in JSON format.', 'CarAdsNextgen')
                    ]);
                    $this->add_control('btn',[
                        'label' => __('Button Text', 'CarAdsNextgen'),
                        'type' => \Elementor\Controls_Manager::TEXT,
                        'default' => '',
                        'description' => __('Optional: Text for the button.', 'CarAdsNextgen')
                    ]);
                    $this->add_control('pre_render',[
                        'label' => __('Use Pre-rendered Content', 'CarAdsNextgen'),
                        'type' => \Elementor\Controls_Manager::SWITCHER,
                        'label_on' => __('Yes', 'CarAdsNextgen'),
                        'label_off' => __('No', 'CarAdsNextgen'),
                        'return_value' => 'yes',
                        'default' => 'yes',
                        'description' => __('Enable to use pre-rendered content for better performance.', 'CarAdsNextgen')
                    ]);

                    $this->add_control('filter',[
                        'label' => __('Override Settings', 'CarAdsNextgen'),
                        'type' => \Elementor\Controls_Manager::TEXTAREA,
                        'default' => '',
                        'description' => __('Optional: JSON string to override default settings.', 'CarAdsNextgen')
                    ]);

                    $this->end_controls_section();
                }
            });
        });
    }
}