<?php
/**
 * @copyright  Copyright (C) 2026 CarAds. All rights reserved.
 * @version 2026.01.20082526
 * @author CarAds Team
 */
namespace CarAdsNextgen\Utils;
use CarAdsNextgen\Basic\Configs as BasicConfigs;
class Configs extends BasicConfigs
{
    protected array $cacheConfig = [];

    public function get(string $name, $setDefault = null) : mixed
    {
        if(array_key_exists($name, $this->cacheConfig)){
            return $this->cacheConfig[$name]?:$setDefault;
        }

        $this->cacheConfig[$name] = $this->_instance($name);

        return $this->cacheConfig[$name]?:$setDefault;
    }

    public function mastersOnly() : array{
        return array_map(function($item){
            return str_replace('_master', '', $item);
        }, array_filter(array_values($this->configFiles), function($name){
            return str_ends_with($name, '_master') && !str_ends_with($name, 'slider_master');
        }));
    }

    private function _instance(string $name) : mixed
    {
        $rawConfig  = $this->offsetGet($name);

        $config     = $rawConfig ? json_decode($rawConfig) : null;

        return match ($name) {
            'settings' => new Configs\Settings($config ?? (object)[]),
            default => $this->other($name, $config),
        };
    }

    private function other(string $name, mixed $config) : mixed{
        if(str_ends_with($name, '_slow')){
            return (object) $config;
        }
        else if(str_ends_with($name, '_master')){
            return (object) $config;
        }
        else if(str_ends_with($name, 'quick')){
            return (object) $config;
        }
        else if(str_ends_with($name, 'slider')){
            return (object) $config;
        }
        else if($name === 'sitemap'){
            return (array) $config;
        }
        else{
            return $config;
        }
    }
}