<?php
namespace CarAdsNextgen\Wordpress;
use CarAdsNextgen\Basic\UpdateConfig;

class Dashboard
{
    static public function init(): void
    {
        add_action('wp_dashboard_setup', function () {
            wp_add_dashboard_widget(
                'carads_nextgen_widget',
                __('CarADS installed', 'CarAdsNextgen'),
                [self::class, 'render']
            );
            wp_add_dashboard_widget(
                'carads_nextgen_settings_widget',
                __('All CarAds Config', 'CarAdsNextgen'),
                [self::class, 'settings']
            );
        });
        // register get request to download list of all versions - php https://download.js.nextgen.carads.io/?format=json
        #add_action('admin_init', function () {
        #    if (isset($_GET['carads_nextgen_dashboard']) && $_GET['carads_nextgen_dashboard'] === '1') {
        #        self::render();
        #        exit;
        #    }
        #});
    }
    static public function render(): void
    {
        $files = self::download_releases();

        echo '<table class="widefat striped">';
        echo '<thead><tr>
        <th>' . esc_html__('Plugin', 'CarAdsNextgen') . '</th>
        <th>' . esc_html__('Version', 'CarAdsNextgen') . '</th>
        <th>' . esc_html__('Requires WP', 'CarAdsNextgen') . '</th>
        <th>' . esc_html__('Requires PHP', 'CarAdsNextgen') . '</th>
        <th>' . esc_html__('Last Updated', 'CarAdsNextgen') . '</th>
      </tr></thead><tbody>';

        if(!(is_plugin_active('c2/app.php') || is_plugin_active('carads/app.php'))){
            unset($files['c2']);
        }
        if(!is_plugin_active('carshop/app.php')){
            unset($files['carshop-update']);
        }
        if(!is_plugin_active('carads-auth/app.php')){
            unset($files['carads-auth-update']);
        }
        if(!is_plugin_active('carads-404/app.php')){
            unset($files['carads-404-update']);
        }
        if(!is_plugin_active('carads-dealership/app.php')){
            unset($files['dealership-update']);
        }
        if(!is_plugin_active('c2-lite/app.php') && !is_plugin_active('carads-lite/app.php')){
            unset($files['c2-lite-update']);
        }

        // check if theme exists
        if(!wp_get_theme('carads-theme')->exists()){
            unset($files['update_theme']);
        }

        foreach ($files as $key => $file) {
            echo '<tr>';
            echo '<td>' . esc_html($key ?? '') . '</td>';
            echo '<td>' . esc_html($file['version'] ?? '') . '</td>';
            echo '<td>' . esc_html($file['requires'] ?? '') . '</td>';
            echo '<td>' . esc_html($file['requires_php'] ?? '') . '</td>';
            echo '<td>' . esc_html($file['last_updated'] ?? '') . '</td>';
            echo '</tr>';
        }
        echo '</tbody></table>';
    }

    static public function settings(): void
    {
        $names = UpdateConfig::current_file_names();
        echo '<div class="carads-dashboard-widget">';
        if ( empty( $names ) ) {
            echo '<p class="description">' . esc_html__( 'No settings files found.', 'CarAdsNextgen' ) . '</p>';
        } else {
            echo '<ul class="ul-disc" style="display: grid; grid-template-columns: repeat(auto-fit, minmax(120px, 1fr)); gap: 10px;">';
            foreach ( $names as $name ) {
                echo '<li>' . esc_html( $name ) . '</li>';
            }
            echo '</ul>';
        }

        echo '</div>';
    }


    static private function download_releases(): array{
        $url = 'https://download.js.nextgen.carads.io/?format=json';
        $response = wp_remote_get($url, ['timeout' => 2]);
        if (is_wp_error($response)) {
            return [];
        }

        $body = wp_remote_retrieve_body($response);
        $data = json_decode($body, true);

        if (json_last_error() !== JSON_ERROR_NONE) {
            return [];
        }

        return is_array($data) ? $data['files'] : [];
    }
}