<?php
/**
 * @copyright  Copyright (C) 2026 CarAds. All rights reserved.
 * @version 2026.01.20082526
 * @author CarAds Team
 */
namespace CarAdsNextgen\Wordpress;

use CarAdsNextgen\Basic\Singleton;
use function CarAdsNextgen\takeHook;

class Debug
{
    use Singleton;

    private function __construct()
    {
        ini_set('display_errors', 1);
        ini_set('display_startup_errors', 1);
        error_reporting(E_ALL);

        if(isset($_GET['elementor_elements_debug'])){
            $this->elementorHook();
        }
        if(isset($_GET['hook'])){
            $this->hook();
        }
    }

    private function elementorHook() : void{
        $el = [];
        $activeElement = null;
        add_action('elementor/frontend/before_render', function ($element) use(&$el, &$activeElement) {
            if(isset($activeElement['el']) && $activeElement['el']->get_id() !== $element->get_id()){
                $id = $activeElement['el']->get_id();
                $el[$id]['tree'][$element->get_id()]=true;
                return;
            }

            $el[$element->get_id()] = [
                'start' => microtime(true),
                'el' => $element,
                'tree' => [],
                'end' => 0,
            ];
            $activeElement = $el[$element->get_id()];
        }, 0);

        add_action('elementor/frontend/after_render', function ($element) use(&$el, &$activeElement) {
            // if $el[$element->get_id()] is not set - then it is not in the list
            if(!isset($el[$element->get_id()])){

                return;
            }

            $time = microtime(true);
            $el[$element->get_id()]['end'] = $time;
            $activeElement = null;
        }, 9999);

        register_shutdown_function(function() use(&$el){
            // show all elementor id and time
            $totalTime = 0;
            echo '<table style="width: 500px; margin: 0 auto">';
            foreach($el AS $id => $time){
                $totalTime += ($time['end'] - $time['start']);
                echo '<tr>';
                echo '<td>' . $id . '</td>';
                echo '<td>' . $time['el']->get_name() . '</td>';
                echo '<td>' . count($time['tree']) . '</td>';
                echo '<td>' . ($time['end'] - $time['start']) . '</td>';
                echo '</tr>';
            }
            // total time
            echo '<tr>';
            echo '<td>Total</td>';
            echo '<td colspan="2">' . $totalTime . '</td>';
            echo '</table>';
        });
    }

    private function functionWithHook($hook, $function) : ?string{
        $hooks = [
            'wp_head' => [
                'wp_enqueue_scripts' => 'wp_enqueue_scripts',
                'wp_robots' => 'wp_robots',
                'wp_print_styles' => 'wp_print_styles',
            ]
        ];

        if(!isset($hooks[$hook])){
            return null;
        }

        return $hooks[$hook][$function] ?? null;
    }

    private function hook() : void{
        $name = !empty($_GET['hook']) ? $_GET['hook'] : 'wp_head';
        $hook = takeHook($name);
        $hook->enable_debug(true);
        register_shutdown_function(function() use($hook, $name){
            // form with get parameter with all filters inside
            echo '<form method="get">';
            echo '<input type="hidden" name="debug" value="1">';
            echo '<select name="hook">';
            foreach($GLOBALS['wp_filter'] AS $hookName => $hookData){
                echo '<option value="' . $hookName . '" ' . ($hookName === $name ? 'selected' : '') . '>' . $hookName . '</option>';
            }
            echo '</select>';
            echo '<input type="submit" value="Submit">';
            echo '</form>';


            print '<h1>' . $name . '</h1>';
            echo '<table>';
            echo '<thead>';
            echo '<tr>';
            echo '<th>Function</th>';
            echo '<th>Time</th>';
            echo '<th>Start</th>';
            echo '<th>End</th>';
            echo '<th>Hook</th>';
            echo '</tr>';
            echo '</thead>';
            $total = 0;
            foreach ($hook->getDebug() as $debug){
                $total += $debug['time'];
                echo '<tr>';
                $hasHook = $this->functionWithHook($name, $debug['function']);
                echo '<td>' . $debug['function'] . '</td>';
                echo '<td>' . $debug['time'] . '</td>';
                echo '<td>' . $debug['start'] . '</td>';
                echo '<td>' . $debug['end'] . '</td>';
                echo '<td>' . ($hasHook ? '<a href="' . esc_url('?debug&hook=' . $hasHook) . '">Yes</a>' : 'No') . '</td>';
                echo '</tr>';
            }
            echo '<tfoot>';
            echo '<tr>';
            echo '<td colspan="4">Total time: ' . $total . '</td>';
            echo '</tr>';
            echo '</table>';
        });
    }
}