<?php
/**
 * @copyright  Copyright (C) 2026 CarAds. All rights reserved.
 * @version 2026.01.20082526
 * @author CarAds Team
 */
namespace CarAdsNextgen\Wordpress\Elementor;
use CarAdsNextgen\Basic\Singleton;
use CarAdsNextgen\Content\Cleanup;
use ElementorPro\Modules\Forms\Classes\Form_Record;
use ElementorPro\Modules\ThemeBuilder\Classes\Conditions_Manager;
use ReflectionException;
use stdClass;

class Elementor
{
    use Singleton;

    private function __construct()
    {
        add_action('elementor/editor/after_save', function($post_id, $post){
            Cleanup::html();
        }, 10, 2);
        add_action('elementor/theme/register_conditions', function(Conditions_Manager $conditions_manager){
            $conditions_manager->get_condition('general')
                ->register_sub_condition(new ViewCondition);
        });
    }
}