<?php
/**
 * @copyright  Copyright (C) 2026 CarAds. All rights reserved.
 * @version 2026.01.20082526
 * @author CarAds Team
 */
namespace CarAdsNextgen\Wordpress\Elementor;
use ElementorPro\Modules\ThemeBuilder\Conditions\Condition_Base;
use function CarAdsNextgen\factory;

class ViewCondition extends Condition_Base
{
    public static function get_type(): string
    {
        return 'carads_nextgen';
    }

    public static function get_priority(): int {
        return 40;
    }

    public function get_label(): ?string
    {
        return __( 'CarWeb', 'CarAdsLight' );
    }

    public function get_name(): string
    {
        return 'carads_nextgen_view';
    }

    public function get_all_label(): string {
        return __( 'CarWeb', 'CarAdsLight' );
    }

    /**
     * @param $args
     * @return bool
     */
    public function check( $args ): bool {
        return factory()->route->active() !== null;
    }
}