<?php
/**
 * @copyright  Copyright (C) 2026 CarAds. All rights reserved.
 * @version 2026.01.20082526
 * @author CarAds Team
 */
namespace CarAdsNextgen\Wordpress;

use CarAdsNextgen\Content\Cleanup;
use CarAdsNextgen\Factory;
use CarAdsNextgen\Basic\Singleton;

class Install
{
    use Singleton{
        getInstance as public init;
    }

    private function __construct()
    {
        add_action('admin_init', [$this, 'admin_init']);
        add_action('upgrader_process_complete', [$this, 'onUpdate'], 10, 2);
    }

    public function admin_init(): void
    {
        $theme      = wp_get_theme();
        $version    = $theme->get('Version');
        $name       = $theme->get('Name');

        if(stripos($name, 'carads') === false){
            add_action('admin_notices', function(){
                echo '<div class="notice notice-error is-dismissible">
                    <p>CarAds theme is not installed or not used</p>
                </div>';
            });
        }

        if(version_compare($version, '1.0.2', '<')){
            // show error message in admin
            add_action('admin_notices', function(){
                echo '<div class="notice notice-error is-dismissible">
                    <p>CarAds theme requires version 1.0.2 or higher</p>
                </div>';
            });
        }

        if(version_compare(phpversion(), '8.3', '<')){
            add_action('admin_notices', function(){
                echo '<div class="notice notice-error is-dismissible">
                    <p>CarAds plugin requires PHP version 8.3 or higher</p>
                </div>';
            });
        }
    }

    static public function activation(): void
    {
        Factory::getInstance()
            ->settings
            ->optimize();

        self::createPaths();
    }

    static public function deactivation() : void
    {
        Factory::getInstance()
            ->settings
            ->optimize();

        self::createPaths();

        Cleanup::logs();
        Cleanup::cache();
    }

    static public function uninstall() : void{
        Factory::getInstance()
            ->settings
            ->cleanup();

        Cleanup::logs();
        Cleanup::cache();
    }

    static private function createPaths(): void
    {
        if(!file_exists(CA_CACHE_PATH)){
            @mkdir(CA_CACHE_PATH, 0777, true);
        }

        if(!file_exists(CA_LOG_PATH)){
            @mkdir(CA_LOG_PATH, 0777, true);
        }

        if(!file_exists(CA_NEXTGEN_PATH . '/../.c2')){
            @mkdir(CA_NEXTGEN_PATH . '/../.c2', 0777, true);
        }
    }

    /**
     * @param mixed $upgrader_object
     * @param $options
     * @return void
     */
    static public function onUpdate(mixed $upgrader_object, $options): void
    {
        if($options['action'] == 'update' && $options['type'] == 'plugin'){
            foreach($options['plugins'] as $each_plugin){
                if($each_plugin == CA_NEXTGEN_BASE){
                    self::activation();

                    Cleanup::logs();
                    Cleanup::cache();
                }
            }
        }

    }
}