<?php
/**
 * @copyright  Copyright (C) 2026 CarAds. All rights reserved.
 * @version 2026.01.20082526
 * @author CarAds Team
 */
namespace CarAdsNextgen\Wordpress;

use CarAdsNextgen\Basic\DefaultRoute;
use CarAdsNextgen\Basic\Singleton;
use CarAdsNextgen\Utils\Configs\Settings;
use CarAdsNextgen\Vendor\FastRoute\Dispatcher;
use CarAdsNextgen\Vendor\FastRoute\RouteCollector;
use function CarAdsNextgen\factory;
use function CarAdsNextgen\Vendor\FastRoute\simpleDispatcher;

class Route implements DefaultRoute
{
    use Singleton;

    public object $dispatcher;

    private ?object $active;


    private array $rewrite = [];
    private array $tags = [
        '%carads%' => '([^?]+)',
        '%slug%' => '([^?]+)',
        '%id%' => '([^?]+)',
        '%type%' => '([^?]+)',
        '%namespace%' => '([^?]+)',
        '%model%' => '([^?]+)',
        '%brand%' => '([^?]+)',
        '%ids%' => '([^?]+)',
    ];

    private function __construct()
    {
        $this->register_dispatcher();
    }

    private function settings(): Settings
    {
        return factory()->configs->get('settings');
    }

    private function routes(): array{
        return factory()->configs->mastersOnly();
    }

    private function register_dispatcher() : void
    {
        $prefix     = $this->settings()->prefix;
        $paths      = $this->routes();
        $allow_any  = is_customize_preview();

        $this->dispatcher = simpleDispatcher(function(RouteCollector $r) use($prefix, $paths, $allow_any){
            $get = $allow_any ? '*' : 'GET';

            if(factory()->configs->exists('sitemap')){
                $r->addRoute($get, "/carads-sitemap-{id}.xml", (object)[
                    'carads'    => 'sitemap',
                    'namespace' => 'sitemap',
                    'path'      => 'sitemap',
                ]);

                $this->rewrite[] = ['^carads-sitemap-([0-9]+).xml$', 'index.php?carads=sitemap&id=$matches[1]'];
            }

            foreach ($paths as $path){
                $brand = "{brand}";
                $model = "{model}";
                $type  = "{type:[\-|\~]}";
                $slug  = "{slug}";
                $id    = "{id:\d+}";

                $r->addGroup("/{$path}-{$prefix}", function (RouteCollector $r) use($type, $model, $brand, $path, $slug, $id, $get, $prefix){
                    $namespace = "{$path}-{$prefix}";
                    $r->addRoute($get, "", (object)[
                        'carads'    => 'product-list',
                        'namespace' => $namespace,
                        'path'      => $path,
                    ]);
                    $this->rewrite[] = ["{$path}-{$prefix}$", 'index.php?carads=products&namespace=' . $namespace];
                    $r->addRoute($get, "/diff-{ids}", (object)[
                        'carads'    => 'product-diff',
                        'namespace' => $namespace,
                        'path'      => $path,
                    ]);
                    $this->rewrite[] = ["{$path}-{$prefix}/diff-([^/]+)$", 'index.php?carads=diff&ids=$matches[1]&namespace=' . $namespace];
                    $r->addRoute($get, "/{$brand}", (object)[
                        'carads'    => 'product-list-filter',
                        'namespace' => $namespace,
                        'path'      => $path,
                        'brand'     => $brand,
                    ]);
                    $this->rewrite[] = ["{$path}-{$prefix}/([^/]+)$", 'index.php?carads=products&brand=$matches[1]&namespace=' . $namespace];
                    $r->addRoute($get, "/{$brand}/{$model}", (object)[
                        'carads'    => 'product-list-filter',
                        'namespace' => $namespace,
                        'path'      => $path,
                        'brand'     => $brand,
                        'model'     => $model,
                    ]);
                    $this->rewrite[] = ["{$path}-{$prefix}/([^/]+)/([^/]+)$", 'index.php?carads=products&brand=$matches[1]&model=$matches[2]&namespace=' . $namespace];

                    $productStruct = (object)[
                        'carads'    => 'product-detail',
                        'namespace' => $namespace,
                        'path'      => $path,
                        'brand'     => $brand,
                        'model'     => $model,
                        'slug'      => $slug,
                        'id'        => $id,
                        'type'      => $type,
                    ];
                    $product_rewrite = 'index.php?carads=product&brand=$matches[1]&model=$matches[2]&slug=$matches[3]&type=$matches[4]&id=$matches[5]&namespace=' . $namespace;

                    $r->addRoute($get, "/{$brand}/{$model}/{$slug}{$type}{$id}", $productStruct);
                    $this->rewrite[] = ["{$path}-{$prefix}/([^/]+)/([^/]+)/([^/]+)([\-|\~]?)([0-9]+)$", $product_rewrite];
                    $r->addRoute($get, "/{$brand}/{$model}/{$slug}{$type}{$id}/carshop", $productStruct);
                    $this->rewrite[] = ["{$path}-{$prefix}/([^/]+)/([^/]+)/([^/]+)([\-|\~])([0-9]+)/carshop$", $product_rewrite];
                    $r->addRoute($get, "/{$brand}/{$model}/{$slug}{$type}{$id}/carboost-{name}", $productStruct);
                    $this->rewrite[] = ["{$path}-{$prefix}/([^/]+)/([^/]+)/([^/]+)([\-|\~])([0-9]+)/carboost-([^/]+)$", $product_rewrite];
                    $r->addRoute($get, "/{$brand}/{$model}/{$slug}{$type}{$id}/debug", $productStruct);
                    $this->rewrite[] = ["{$path}-{$prefix}/([^/]+)/([^/]+)/([^/]+)([\-|\~])([0-9]+)/debug$", $product_rewrite];
                });
            }
        });


        $this->active = $this->register();
    }

    /**
     * @return void
     *
     */
    public function register_rewrites() : void{
        foreach ($this->tags as $tag){
            add_rewrite_tag( $tag[0], $tag[1] );
        }

        foreach ($this->rewrite as $rule){
            add_rewrite_rule($rule[0], $rule[1], $rule[2] ?? 'top');
        }
    }

    /**
     * @return object|null
     */
    private function register(): ?object
    {
        $info = $this->dispatcher->dispatch(
            $_SERVER['REQUEST_METHOD'],
            factory()->url
        );

        return match ($info[0]) {
            Dispatcher::FOUND => (object)[
                'controller' => $info[1]->carads,
                'namespace' => $info[1]->namespace,
                'path' => $info[1]->path ?? '',
                'params' => (object)($info[2] ?? []),
            ],
            default => null,
        };
    }

    public function active(): ?object
    {
        return $this->active;
    }
}