<?php
/**
 * @copyright  Copyright (C) 2026 CarAds. All rights reserved.
 * @version 2026.01.20082526
 * @author CarAds Team
 */

use CarAdsNextgen\RestApi\AllConfigs;
use CarAdsNextgen\RestApi\CustomCSS;
use CarAdsNextgen\RestApi\FindConfig;
use CarAdsNextgen\RestApi\HandShake;
use CarAdsNextgen\RestApi\LoadPage;
use CarAdsNextgen\RestApi\Ping;
use CarAdsNextgen\RestApi\Settings;
use CarAdsNextgen\RestApi\UpdateConfig;
use CarAdsNextgen\Shortcode\Banner;
use CarAdsNextgen\Shortcode\Contact;
use CarAdsNextgen\Shortcode\OpeningTimes;
use CarAdsNextgen\Shortcode\Search;
use CarAdsNextgen\Shortcode\ServiceContact;
use CarAdsNextgen\Shortcode\Slider;
use CarAdsNextgen\Shortcode\SlowSearch;
use CarAdsNextgen\Wordpress\Admin;
use CarAdsNextgen\Wordpress\Dashboard;
use CarAdsNextgen\Wordpress\Customize;
use CarAdsNextgen\Wordpress\Elementor\Elementor;
use CarAdsNextgen\Wordpress\Install;
use CarAdsNextgen\Wordpress\Rewrite;
use function CarAdsNextgen\Basic\simpleUpdater;
use function CarAdsNextgen\factory;

return new class {
    public function __construct()
    {
        load_plugin_textdomain('CarAdsNextgen');
        Install::init();
        Customize::getInstance(); // can be run after init
        Rewrite::init(); // 99% sure this can run after init
        Admin::init(); // think yes after init

        Elementor::getInstance();

        $this->rest_api();
        $this->shortcode();
        $this->register();
    }

    private function register(): void
    {
        add_filter('carads_config_files', function($files){
            return array_merge($files, ['c2' => factory()->configs]);
        });

        Dashboard::init();

        add_filter('admin_init', function(){
            ini_set('memory_limit', '1024M');
            ini_set('max_execution_time', 300);
            simpleUpdater(
                url: 'https://download.js.nextgen.carads.io/update.json',
                version: CA_NEXTGEN_VERSION,
                base: CA_NEXTGEN_BASE,
                icons: [
                    '1x' => CA_NEXTGEN_URL . 'assets/256.png',
                    '2x' => CA_NEXTGEN_URL . 'assets/icon.png',
                    'default' => CA_NEXTGEN_URL . 'assets/128.png',
                ]
            );
        });
    }

    private function shortcode() : void{
        Search::addShortcode()
            ->elementor_register();
        Slider::addShortcode()
            ->elementor_register();
        SlowSearch::addShortcode()
            ->elementor_register();
        OpeningTimes::addShortcode()
            ->elementor_register();
        Banner::addShortcode()
            ->elementor_register();
        Contact::addShortcode()
            ->elementor_register();
        ServiceContact::addShortcode()
            ->elementor_register();
    }

    private function rest_api() : void{
        AllConfigs::addApi();
        FindConfig::addApi();
        HandShake::addApi();
        LoadPage::addApi();
        Ping::addApi();
        UpdateConfig::addApi();
        CustomCSS::addApi();
        Settings::addApi();
    }
};