<?php
/**
 * @copyright  Copyright (C) 2026 CarAds. All rights reserved.
 */
defined('ABSPATH') or die('');
/**
 * @var WP_Customize_Manager $customize
 */

function filter_all_carads_settings(WP_Customize_Manager $customize): object
{
    // all filter that start with CarAdsNextgen will
    $filter = [];
    foreach($customize->settings() as $key => $setting){
        if(str_starts_with($key, 'CarAdsNextgen')){
            $newKey = str_replace('CarAdsNextgen', '', $key);
            $filter[strtolower($newKey)] = $setting->value() ?? $setting->default();
        }
    }

    return (object) $filter;
}

$settings = filter_all_carads_settings($customize);
?>
/** CarAds Css Override */
:root{
    --ca-gray-1: <?php echo $settings->css_color_gray_1; ?>;
    --ca-gray-2: <?php echo $settings->css_color_gray_2; ?>;
    --ca-gray-3: <?php echo $settings->css_color_gray_3; ?>;
    --ca-gray-4: <?php echo $settings->css_color_gray_4; ?>;
    --ca-gray-5: <?php echo $settings->css_color_gray_5; ?>;
    --ca-gray-6: <?php echo $settings->css_color_gray_6; ?>;
    --ca-gray-7: <?php echo $settings->css_color_gray_7; ?>;
    --ca-gray-8: <?php echo $settings->css_color_gray_8; ?>;
    --ca-gray-9: <?php echo $settings->css_color_gray_9; ?>;

    --ca-stone-1: <?php echo $settings->css_color_stone_1; ?>;
    --ca-stone-2: <?php echo $settings->css_color_stone_2; ?>;
    --ca-stone-3: <?php echo $settings->css_color_stone_3; ?>;
    --ca-stone-4: <?php echo $settings->css_color_stone_4; ?>;
    --ca-stone-5: <?php echo $settings->css_color_stone_5; ?>;
    --ca-stone-6: <?php echo $settings->css_color_stone_6; ?>;
    --ca-stone-7: <?php echo $settings->css_color_stone_7; ?>;
    --ca-stone-8: <?php echo $settings->css_color_stone_8; ?>;
    --ca-stone-9: <?php echo $settings->css_color_stone_9; ?>;
}
</style>