<?php
/**
 * @copyright  Copyright (C) 2026 CarAds. All rights reserved.
 */
defined('ABSPATH') or die('No script kiddies please!');
?>
<script type="text/javascript">
    if (typeof jQuery !== 'undefined') {
        jQuery(document).ready(() => {
            const pushState = history.pushState;
            const back = history.back;
            history.back = function () {
                back.apply(history, arguments);
                console.log('back');
            };
            history.pushState = function () {
                pushState.apply(history, arguments);
                console.log('pushState');
            };
            function loadConfig(find, url, onError){
                jQuery.ajax({
                    url: '<?php echo get_rest_url(null, 'carads/nextgen/config'); ?>',
                    type: 'GET',
                    data: {find},
                    dataType: 'json',
                    error: function (xhr, status, error) {
                        if(typeof onError === 'function')
                        {
                            onError();
                        }
                    },
                    success: function (data) {
                        // if "carads_search_settings" is not set, set it
                        if(jQuery('#carads_search_settings').length === 0)
                        {
                            jQuery('body').append('<script id="carads_search_settings"><\/script>');
                        }

                        if(jQuery('#content').length > 0)
                        {
                            jQuery('#content').after('<div id="master"></div>');
                            jQuery('#content').hide();
                        }
                        else
                        {
                            jQuery('main').after('<div id="master"></div>');
                            jQuery('main').hide();
                        }

                        history.pushState({}, '', url);
                        jQuery('#carads_search_settings').html(JSON.stringify(data));
                        jQuery('#master').html('<div id="app" class="carads ca-relative ca-min-h-screen"></div>');
                        window.__carads_nextgen_init();
                        addHook('router_404', (ob) => {

                            jQuery('#master').remove();

                            if(jQuery('#content').length > 0)
                            {
                                jQuery('#content').show();
                            }
                            else
                            {
                                jQuery('main').hide();
                            }
                            // remove hook
                            window.__carads_hooks = window.__carads_hooks.filter((item) => {
                                return item.hook !== 'router_404';
                            });
                        });
                    }
                });
            }

            function addHook(hook, callback){
                if(!('__carads_hooks' in window))
                {
                    window.__carads_hooks = [];
                }

                window.__carads_hooks.push({
                    hook,
                    callback
                });
            }


            if(jQuery('#content, main').length > 0)
            {
                if(jQuery('#quick_search').length > 0)
                {
                    addHook('quick_search_link', (ob) => {
                        loadConfig(ob.key, ob.url, () => {
                            window.location.href = ob.url;
                        });
                    });
                }

                if(jQuery('.carads.slider').length > 0)
                {
                    addHook('car_ads_slider_link', (ob) => {
                        loadConfig(ob.key, ob.url);
                    });
                }
            }
        });
    }
    else {
        console.warn('jQuery is not loaded.');
    }
</script>