<?php
/**
 * @copyright  Copyright (C) 2026 CarAds. All rights reserved.
 */

use function CarAdsNextgen\Basic\createAttributes;

defined('ABSPATH') or die('No script kiddies please!');
/**
 * @var stdClass $config
 * @var ?string $body
 */

$attr = [
    'data-version' => '2',
    'class' => 'ca-relative ca-min-h-screen',
    'style' => 'min-height: 100rem',
    'id' => 'app',
];


// if body exist, i need add style to blur content until js loads
if ($body) {
    $attr['class'] .= ' carads-pre-rendered-content';
}
$attrString = createAttributes($attr);
?>
<main class="carads">
    <div <?php echo $attrString; ?>>
        <?php if ($body) : ?>
            <div class="carads-search-pre-rendered-content">
                <noscript>
                    <p class="max-container ca-block ca-bg-red-100 ca-text-red-700 ca-p-4 ca-m-4 ca-border ca-border-red-400 ca-rounded ca-text-center">
                        <?php esc_html_e('Vi kan se du ikke slået javascript til, derfor vil vi ikke vise alt data correct.', 'carads-nextgen'); ?>
                        <br />
                        <?php esc_html_e('Derfor beder vi dig om at slå det til', 'carads-nextgen'); ?>
                    </p>
                </noscript>
                <?php echo $body; ?>
            </div>
        <?php else: ?>
        <div class="ca-h-screen ca-flex ca-flex-col ca-justify-center ca-items-center carads-full-loading">
            <div class="loading max-container ca-h-[400px]">
                <div class="ca-flex ca-flex-col ca-justify-center ca-items-center ca-h-full">
                    <div role="status">
                        <svg
                            aria-hidden="true"
                            class="ca-w-24 ca-h-24 ca-mr-2 ca-animate-spin ca-fill-blue-600"
                            viewBox="0 0 100 101"
                            fill="none"
                            xmlns="http://www.w3.org/2000/svg"
                        >
                            <path
                                d="M100 50.5908C100 78.2051 77.6142 100.591 50 100.591C22.3858 100.591 0 78.2051 0 50.5908C0 22.9766 22.3858 0.59082 50 0.59082C77.6142 0.59082 100 22.9766 100 50.5908ZM9.08144 50.5908C9.08144 73.1895 27.4013 91.5094 50 91.5094C72.5987 91.5094 90.9186 73.1895 90.9186 50.5908C90.9186 27.9921 72.5987 9.67226 50 9.67226C27.4013 9.67226 9.08144 27.9921 9.08144 50.5908Z"
                                fill="currentColor"
                            />
                            <path
                                d="M93.9676 39.0409C96.393 38.4038 97.8624 35.9116 97.0079 33.5539C95.2932 28.8227 92.871 24.3692 89.8167 20.348C85.8452 15.1192 80.8826 10.7238 75.2124 7.41289C69.5422 4.10194 63.2754 1.94025 56.7698 1.05124C51.7666 0.367541 46.6976 0.446843 41.7345 1.27873C39.2613 1.69328 37.813 4.19778 38.4501 6.62326C39.0873 9.04874 41.5694 10.4717 44.0505 10.1071C47.8511 9.54855 51.7191 9.52689 55.5402 10.0491C60.8642 10.7766 65.9928 12.5457 70.6331 15.2552C75.2735 17.9648 79.3347 21.5619 82.5849 25.841C84.9175 28.9121 86.7997 32.2913 88.1811 35.8758C89.083 38.2158 91.5421 39.6781 93.9676 39.0409Z"
                                fill="currentFill"
                            />
                        </svg>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <?php endif; ?>
    <script type="application/json" id="carads_search_settings"><?php echo json_encode($config); ?></script>
</main>
<style type="text/css">
    .carads-search-pre-rendered-content{
        filter: blur(1%);
        transition: filter 0.3s ease-in-out;
        position: relative;
    }
    .carads-search-pre-rendered-content .filter-sort-select,
    .carads-search-pre-rendered-content button{
        pointer-events: none;
    }
    .carads-search-pre-rendered-content .car-list-item-price,
    .carads-search-pre-rendered-content .car-list-item-financing{

        filter: blur(10px);
    }
</style>