<?php
/**
 * @copyright  Copyright (C) 2026 CarAds. All rights reserved.
 * @version   2026.01.20082528
 * @author    CarAds Team
 */
namespace CarAdsLite\Basic;
/**
 * Trait DefaultSingleton
 *
 * @package CarAdsLite\Basic
 */
trait AbstractSingleton
{
	/**
	 * @var self[]
	 */
	protected static array $instance = [];

    /**
     * @return self
     */
	public static function getInstance() : self
	{
		return static::$instance[static::class] ?? (self::$instance[static::class] = new static);
	}
}