<?php
/**
 * @copyright  Copyright (C) 2026 CarAds. All rights reserved.
 * @version   2026.01.20082528
 * @author    CarAds Team
 */
namespace CarAdsLite\Basic;
class BasicSettings implements \JsonSerializable
{
    protected array $settings = [
    ];

    public function __get($name){

        if(array_key_exists($name, $this->settings)){
            return $this->returnType(
                get_option($this->settings[$name][0], $this->settings[$name][1]),
                $this->settings[$name][2]
            );
        }
        else if(str_ends_with($name, '_default_value')){
            $base_name = substr($name, 0, -strlen('_default_value'));
            if(array_key_exists($base_name, $this->settings)){
                return $this->returnType($this->settings[$base_name][1], $this->settings[$base_name][2]);
            }
            throw new \InvalidArgumentException("Setting '$base_name' does not exist.");
        }
        else if (str_ends_with($name, '_key')){
            $base_name = substr($name, 0, -strlen('_key'));
            if(array_key_exists($base_name, $this->settings)){
                return $this->settings[$base_name][0];
            }
            throw new \InvalidArgumentException("Setting '$base_name' does not exist.");
        }

        throw new \InvalidArgumentException("Setting '$name' does not exist.");
    }

    protected function returnType($value, $type) : mixed{
        return match ($type){
            'bool' => (bool) $value,
            'int' => (int) $value,
            'string' => (string) $value,
            'float' => (float) $value,
            default => $value
        };
    }


    public function __isset($name){
        return array_key_exists($name, $this->settings);
    }

    public function cleanup(): void{
        foreach ($this->settings as $setting){
            delete_option($setting[0]);
        }
    }

    public function optimize(): void{
        foreach ($this->settings as $name => $setting){
            replace_option(
                $setting[0],
                $this->toDatabase($this->{$name}, $setting[2]),
                $setting[3]
            );
        }
    }

    public function toDatabase($value, $type) : mixed
    {
        return match ($type){
            'bool', 'int' => (int) $value,
            'string' => (string) $value,
            'float' => (float) $value,
            default => $value
        };
    }

    public function update(string $name, mixed $value, $autoload = null, $force = true): void
    {
        if(array_key_exists($name, $this->settings)){
            if($force){
                delete_option($this->settings[$name][0]);
            }

            replace_option($this->settings[$name][0], $this->toDatabase($value, $this->settings[$name][2]), $autoload);
        }
    }

    public function jsonSerialize(): array
    {
        return [];
    }
}