<?php
/**
 * @copyright  Copyright (C) 2026 CarAds. All rights reserved.
 * @author CarAds Team
 * @version 2026.01.20082528
 */
namespace CarAdsLite;
use CarAdsLite\Basic\DefaultFactory;
use CarAdsLite\Basic\Singleton;
use CarAdsLite\WordPress\Settings;

/**
 * Factory class for CarAds Lite plugin.
 *
 * @property-read Settings $settings The settings instance.
 */
class Factory extends DefaultFactory
{
    use Singleton;

    protected function settings(): Settings
    {
        return Settings::getInstance();
    }

    public function __get(string $name): mixed
    {
        return match ($name) {
            'settings' => $this->settings(),
            default => parent::__get($name),
        };
    }
}