<?php
/**
 * @copyright  Copyright (C) 2026 Shared. All rights reserved.
 *
 */
namespace CarAdsLite\Shortcode;
use CarAdsLite\Basic\ElementorWidget;
use CarAdsLite\Basic\Shortcode;
use function CarAdsLite\Basic\css_inject_helper;
use function CarAdsLite\Basic\current_factory;
use function CarAdsLite\Basic\fetch_pre_rendered;

class OpeningTimes extends Shortcode
{
    /**
     * @var string
     */
    protected string $tag = 'carads-opening-times';

    public function render($args = [], $content = null) : string
    {
        $config = new \stdClass;

        if($content !== null){
            $config = @json_decode(trim($content));
        }

        if(json_last_error() !== JSON_ERROR_NONE)
        {
            return 'You need add config to shortcode';
        }

        $cache = is_user_logged_in();
        $config->disable_cache = $cache;


        $config->id = $config?->id ?? (isset(current_factory()->settings->cid) ? current_factory()->settings->cid : -1);

        $jsonSettings = json_encode($config);
        $cacheKey = md5($jsonSettings);
        $body = '';

        if(true){
            $body = $this->pre_render((int) $config->id, $jsonSettings, $cacheKey);
        }

        return $this->inlineHtml($jsonSettings, $body);
    }

    public function enqueue() : void{
        wp_enqueue_style('car-ads-opening-times', css_inject_helper('department/opening_times/basic.css'));
    }

    private function inlineHtml(string $config, ?string $body) : string{
        $time = CA_TIME;
        $body = !empty($body) ? $body : 'indlæser Åbningstider...';
        return <<<HTML
            <div class="carads-wrapper">
                <div class="carads" data-time="{$time}">
                    <div class="carads-opening-times" data-settings='{$config}'>
                        {$body}
                    </div>
                </div>
            </div>
HTML;
    }

    protected function pre_render(int $id, string $config, string $key) : string{
        // if we have cache file, return it
        if(defined('WP_CONTENT_DIR')){
            // key is md5 of config that we use as cache for 1 hour, but if day changes, we clear cache
            $cachePath = WP_CONTENT_DIR . '/cache/carads-nextgen/opening-times/';
            if(!is_dir($cachePath)) {
                @mkdir($cachePath, 0755, true);
            }
            $cacheFile = $cachePath . $key . '-2' . date('Y-m-d') . '.html';

            if (file_exists($cacheFile) && (time() - filemtime($cacheFile) < 3600)) {
                return @file_get_contents($cacheFile);
            }

            $body = fetch_pre_rendered('https://ssr.js.nextgen.carads.io/opening-times/' . $id . '?config=' . urlencode($config));

            $body = '<!-- Cached copy, generated at ' . date('Y-m-d H:i:s') . ' -->' . PHP_EOL . $body;

            @file_put_contents($cacheFile, $body);
            return $body;
        }
    }


    public function elementor_register() : void{
        add_action('elementor/widgets/register', function($widgets_manager) {
            $widgets_manager->register(new class extends ElementorWidget {
                protected string $title = 'CarAds Opening Times';
                protected string $tag = 'CarAdsOpeningTimes';
                protected string $icon = 'eicon-clock';
                protected array $category = ['carads-widgets'];

                protected function render() : void{
                    $s = $this->get_settings_for_display();
                    $json = $s['config'] ?? '';

                    if(!empty($json)){
                        $s = trim($json);
                    } else {
                        $s = '{}';
                    }

                    echo do_shortcode('[carads-opening-times]' . $json . '[/carads-opening-times]');
                }

                protected function register_controls() : void
                {
                    $this->start_controls_section(
                        'section_content',
                        [
                            'label' => __('Content', 'carads-nextgen'),
                        ]
                    );
                    $this->add_control(
                        'config',
                        [
                            'label' => __('Configuration (JSON)', 'carads-nextgen'),
                            'type' => \Elementor\Controls_Manager::TEXTAREA,
                            'default' => '',
                            'placeholder' => '{"id":12345}',
                        ]
                    );
                    $this->end_controls_section();
                }
            });
        });
    }
}