<?php
/**
 * @copyright  Copyright (C) 2026 CarAds. All rights reserved.
 * @author CarAds Team
 * @version 2026.01.20082528
 */
namespace CarAdsLite\WordPress;
use CarAdsLite\Basic\CustomizeHelper;
use CarAdsLite\Basic\Singleton;
use function CarAdsLite\factory;

class Customize
{
    use Singleton{
        getInstance as public init;
    }

    private function __construct()
    {
        add_action('customize_register', [$this, 'register'], 1, 99);
    }

    public function register(\WP_Customize_Manager $customize) : void
    {
        $panel = CustomizeHelper::panel(
            customize: $customize,
            key: 'carads_lite_settings',
            title: __( 'CarAds Lite', 'CarAdsLite' ),
        );

        $section = CustomizeHelper::Section(__( 'CarAds Lite Indstillinger', 'CarAdsLite' ), $panel->id, $customize);

        CustomizeHelper::Select(
            customize: $customize,
            key: 'CarAdsLitePlatformAPI',
            label: __( 'API', 'CarAdsLite' ),
            default: factory()->settings->platform_api_default_value,
            choices: [
                Settings::PLATFORM_API_NONE => __( 'None - default', 'CarAdsLite'),
                Settings::PLATFORM_API_NEXTGEN => __( 'Carads - NextGen', 'CarAdsLite'),
                Settings::PLATFORM_API_NEXTGEN_TEST => __( 'Carads - NextGen Test', 'CarAdsLite'),
                Settings::PLATFORM_API_SERVICE_ADS => __( 'ServiceAds', 'CarAdsLite'),
            ],
            section: $section->id,
            description: __('Vælg hvilken platform API der skal bruges.', 'CarAdsLite')
        );

        CustomizeHelper::Checkbox(
            customize: $customize,
            key: 'CarAdsLiteShadowRoot',
            label: __( 'Shadow Root', 'CarAdsLite' ),
            default: factory()->settings->shadow_root_default_value,
            section: $section->id,
            description: __('Aktivér eller deaktiver brugen af Shadow Root.', 'CarAdsLite')
        );

        CustomizeHelper::Text(
            customize: $customize,
            key: 'CarAdsLiteClientId',
            label: __( 'Client ID', 'CarAdsLite' ),
            default: factory()->settings->environment_default_value,
            section: $section->id,
            description: __('Indtast Client ID for den valgte platform API.', 'CarAdsLite'),
            sanitize_callback: CustomizeHelper::SANITIZE_EMPTY_STRING
        );

        CustomizeHelper::Select(
            customize: $customize,
            key: 'CarAdsLiteScript',
            label: __( 'Script Version', 'CarAdsLite' ),
            default: factory()->settings->script_default_value,
            choices: [
                'master' => __( 'Master - Stabil', 'CarAdsLite' ),
                'develop' => __( 'Develop - Nyeste funktioner (kan være ustabil)', 'CarAdsLite' ),
            ],
            section: $section->id,
            description: __('Vælg hvilken version af scriptet der skal indlæses.', 'CarAdsLite')
        );
    }
}