<?php
/**
 * @copyright  Copyright (C) 2026 CarAds. All rights reserved.
 * @author CarAds Team
 * @version 2026.01.20082528
 */
namespace CarAdsLite\WordPress;
use CarAdsLite\Basic\BasicSettings;
use CarAdsLite\Basic\Singleton;

/**
 * Class Settings
 *
 * @package CarAdsLite\WordPress
 *
 * @property-read int $platform_api
 * @property-read bool $shadow_root
 * @property-read int $environment
 * @property-read int $cid alias of environment
 * @property-read string $script
 * @property-read string $form_layout
 *
 * @property-read string $platform_api_default_value
 * @property-read string $shadow_root_default_value
 * @property-read string $environment_default_value
 * @property-read string $cid_default_value alias of environment_default_value
 * @property-read string $script_default_value
 * @property-read string $form_layout_default_value
 *
 * @property-read string $platform_api_key
 * @property-read string $shadow_root_key
 * @property-read string $environment_key
 * @property-read string $cid_key alias of environment_key
 * @property-read string $script_key
 * @property-read string $form_layout_key
 */
class Settings extends BasicSettings
{
    use Singleton;

    CONST int PLATFORM_API_NEXTGEN = 0;
    CONST int PLATFORM_API_NEXTGEN_TEST = 1;
    CONST int PLATFORM_API_SERVICE_ADS = 2;
    const int PLATFORM_API_NONE = -1;

    protected array $settings = [
        'platform_api' => ['CarAdsLitePlatformAPI', self::PLATFORM_API_NONE, 'int'],
        'shadow_root' => ['CarAdsLiteShadowRoot', true, 'bool'],
        'environment' => ['CarAdsLiteClientId', -1, 'int'],
        'script' => ['CarAdsLiteScript', 'master', 'string'],
        'cid' => ['CarAdsLiteClientId', -1, 'int'],
        'form_layout' => ['CarAdsLiteFormLayout', 'floating', 'string'],
    ];
}