<?php
/**
 * @copyright  Copyright (C) 2026 CarAds. All rights reserved.
 * @author CarAds Team
 * @version 2026.01.20082528
 */
namespace CarAdsLite\WordPress;
use CarAdsLite\Basic\Singleton;
use function CarAdsLite\Basic\css_inject_helper;
use function CarAdsLite\Basic\simple_cdn_version;
use function CarAdsLite\Basic\simpleUpdater;
use function CarAdsLite\factory;

class Wordpress
{
    private string $slug;

    private int $time = 0;

    use Singleton{
        getInstance as public init;
    }

    private function __construct(){
        $this->slug = dirname(CA_LITE_NEXTGEN_BASE);
        $this->time = (int) time();

        add_filter('wp_head', [$this, 'head'], 11, 1);
        add_filter('wp_enqueue_scripts', [$this, 'css'], 99);
        add_filter('wp_script_attributes', function (array $data) {
            if($data['id'] === 'carads-main-js-module'){
                // https://developer.mozilla.org/en-US/docs/Web/HTML/Reference/Attributes/crossorigin
                $data['crossorigin'] = 'anonymous';
            }

            return $data;
        }, 10, 2);

        simpleUpdater(
            url: 'https://download.js.nextgen.carads.io/c2-lite-update-beta.json',
            version: CA_LITE_NEXTGEN_VERSION,
            base: CA_LITE_NEXTGEN_BASE,
            icons: [
                '1x' => CA_LITE_NEXTGEN_URL . 'assets/256.png',
                '2x' => CA_LITE_NEXTGEN_URL . 'assets/icon.png',
                'default' => CA_LITE_NEXTGEN_URL . 'assets/128.png'
            ]
        );
    }

    public function css(): void
    {
        $css = $this->cssFile();
        wp_enqueue_style('carads-main', $css, [], null);

        $settings = factory()->settings;
        wp_enqueue_style('car-ads-icons', css_inject_helper('icons.css'), [], null);
        wp_enqueue_style('car-ads-opening-times', css_inject_helper('department/opening_times/basic.css'));

        if ($settings->form_layout === 'floating'){
            wp_enqueue_style('car-ads-form-floating', css_inject_helper('forms/floating-form.css'), [], null);
        }
        else if($settings->form_layout === 'floating-outlined'){
            wp_enqueue_style('car-ads-form-floating-outlined', css_inject_helper('forms/floating-outlined-form.css'), [], null);
        }
        else if($settings->form_layout === 'old-school'){
            wp_enqueue_style('car-ads-form-old', css_inject_helper('forms/old-school.css'), [], null);
        }
        else {
            wp_enqueue_style('car-ads-form-all', css_inject_helper('forms/_form.css'), [], null);
        }

        $src = $this->jsFile();

        wp_register_script_module(
            'carads-main',
            $src,
            []
        );

        wp_enqueue_script_module('carads-main');
    }

    public function head() : void{
        echo '<link rel="dns-prefetch" href="https://nextgen.carads.io" />';
        echo '<link rel="dns-prefetch" href="https://js.nextgen.carads.io" />';
        echo '<link rel="preconnect" href="https://nextgen.carads.io" />';
        echo '<link rel="preconnect" href="https://js.nextgen.carads.io" />';
    }

    public function cssFile() : ?string{
        return css_inject_helper('optimize.css');
    }

    public function jsFile() : string{
        $version = simple_cdn_version();
        $query = http_build_query($this->mainJsQuery());

        return (CA_LITE_TEST || ($version === 'localhost' || $version === 'local')) ?
            ("http://localhost:3000/src/main.js?{$query}") :
            ("https://js.nextgen.carads.io/{$version}/assets/main.js?{$query}");
    }

    private function mainJsQuery() : array {
        $settings = factory()->settings;

        return [
            'v' => $this->time,
            'wx' => CA_LITE_NEXTGEN_VERSION,
            'environment' => $settings->environment,
            'shadow_root' => $settings->shadow_root ? 1 : 0,
            'lite' => '1',
            'platform_api' => $settings->platform_api,
        ];
    }
}