<?php
/**
 * @copyright  Copyright (C) 2026 CarAds. All rights reserved.
 * @author CarAds Team
 * @version 2026.01.20082528
 *
 */
spl_autoload_register(function ($class) {
    $prefix = 'CarAdsLite\\';
    $base_dir = __DIR__ . '/../includes/';
    $len = strlen($prefix);

    if (strncmp($prefix, $class, $len) !== 0) {
        return;
    }

    $relative_class = substr($class, $len);
    $file = $base_dir . str_replace('\\', '/', $relative_class) . '.php';

    if (file_exists($file)) {
        require $file;
    }
});

include_once __DIR__ . '/Basic/_functions.php';
include_once __DIR__ . '/_global.php';