<?php
/**
 * @copyright  Copyright (C) 2026 CarAds. All rights reserved.
 * @author CarAds Team
 * @version 2026.01.20082528
 */
use CarAdsLite\Shortcode\Contact;
use CarAdsLite\Shortcode\OpeningTimes;
use CarAdsLite\Shortcode\ServiceContact;
use CarAdsLite\WordPress\Customize;
use CarAdsLite\WordPress\Wordpress;
use function CarAdsLite\Basic\elementor_reload_preview;

return new class {
    public function __construct()
    {
        Wordpress::init();
        Customize::init();

        $this->shortcodes();
    }

    private function shortcodes() : void
    {
        // check if shortcodes are already registered
        Contact::addShortcode()
            ->elementor_register();
        ServiceContact::addShortcode()
            ->elementor_register();
        OpeningTimes::addShortcode()
            ->elementor_register();

        add_filter('elementor/preview/enqueue_scripts', function(){
            elementor_reload_preview();
        }, 999);
    }
};