<?php
/**
 * @copyright  Copyright (C) 2026 CarAds. All rights reserved.
 * @version 2026.01.20082526
 * @author CarAds Team
 */
namespace CarAds404;
use CarAds404\Basic\Singleton;
use CarAds404\Utils\Settings;
use CarAdsNextgen\Wordpress\Route as CarAdsRoute;
use CarShop\Utils\Configs;
use CarShop\Utils\Route as CarShopRoute;
use function CarShop\factory as carshop_factory;
use Exception;

/**
 * Class Factory
 *
 * @property-read bool $carads_exists
 * @property-read bool $carshop_exists
 * @property-read CarAdsRoute $carads_route
 * @property-read CarShopRoute|null $carshop_route
 * @property-read Configs|null $carshop_config
 * @property-read Settings $settings
 */
class Factory
{
    use Singleton;

    private function __construct()
    {

    }

    private function carads_exists(): bool
    {
        return (
            is_plugin_active('c2/app.php') ||
            is_plugin_active('carads/app.php')
        );
    }

    private function caradsRoute(): ?CarAdsRoute
    {
        if(class_exists('CarAdsNextgen\Wordpress\Route')) {
            return CarAdsRoute::getInstance();
        }

        return null;
    }

    private function carshop_exists(): bool
    {
        return (
            is_plugin_active('carshop/app.php')
        );
    }

    private function carshopRoute(): ?CarShopRoute
    {
        if($this->carshop_exists()){
            return carshop_factory()->route;
        }
    }

    private function CarShopConfig(): ?Configs{
        if($this->carshop_exists()){
            return carshop_factory()->configs;
        }

        return null;
    }

    private function settings(): Settings
    {
        return Settings::getInstance();
    }

    /**
     * @throws Exception
     */
    public function __get(string $name)
    {
        return match ($name) {
            'carads_exists' => $this->carads_exists(),
            'carshop_exists' => $this->carshop_exists(),
            'carads_route' => $this->caradsRoute(),
            'carshop_route' => $this->carshopRoute(),
            'carshop_config' => $this->CarShopConfig(),
            'settings' => $this->settings(),
            default => throw new Exception("Property {$name} does not exist in " . __CLASS__),
        };
    }
}