<?php
/**
 * @copyright  Copyright (C) 2026 CarAds. All rights reserved.
 * @version 2026.01.20082526
 * @author CarAds Team
 */
namespace CarAds404\Utils;

use CarAds404\Basic\Singleton;

/**
 * Class Settings
 * @package CarAds404\Utils
 *
 * @property int $video_url
 * @property string $heading
 * @property string $description
 * @property string $additional_info
 * @property bool $show_cars_from_feed
 * @property bool $show_cars_from_carshop
 * @property bool $simple_404
 * @property bool $fast_404
 * @property string $button_1_text
 * @property string $button_1_link
 * @property string $button_2_text
 * @property string $button_2_link
 * @property string $button_3_text
 * @property string $button_3_link
 * @property string $button_4_text
 * @property string $button_4_link
 * @property string $button_5_text
 * @property string $button_5_link
 * @property string $button_6_text
 * @property string $button_6_link
 *
 * @property-read int $video_url_default_value
 * @property-read string $heading_default_value
 * @property-read string $description_default_value
 * @property-read string $additional_info_default_value
 * @property-read bool $show_cars_from_feed_default_value
 * @property-read bool $show_cars_from_carshop_default_value
 * @property-read bool $simple_404_default_value
 * @property-read bool $fast_404_default_value
 *
 * @property-read string $video_url_key
 * @property-read string $heading_key
 * @property-read string $description_key
 * @property-read string $additional_info_key
 * @property-read string $show_cars_from_feed_key
 * @property-read string $show_cars_from_carshop_key
 * @property-read string $simple_404_key
 * @property-read string $fast_404_key
 */
class Settings
{
    use Singleton;

    private array $settings = [
        'video_url' => ['CarAds404VideoURL', 0, 'int'],
        'heading' => ['CarAds404Heading', 'Ups! Denne vej førte os til en blindgyde ...', 'string'],
        'description' => ['CarAds404Description', 'Vi kunne ikke finde den side, du leder efter.', 'string'],
        'additional_info' => ['CarAds404AdditionalText', 'Men bare rolig! Vi har masser af spændende biler og tilbud, du kan tjekke ud. Klik på knappen herunder, så er du hurtigt på rette vej mod din næste bil.', 'string'],
        'show_cars_from_feed' => ['CarAds404ShowCarsFromFeed', true, 'bool'],
        'show_cars_from_carshop' => ['CarAds404ShowCarsFromCarshop', true, 'bool'],
        'simple_404' => ['CarAds404Simple404', false, 'bool'],
        'fast_404' => ['CarAds404Fast404', false, 'bool'],

        'button_1_text' => ['CarAds404ButtonText_1', '', 'string'],
        'button_1_link' => ['CarAds404ButtonLink_1', '', 'string'],
        'button_2_text' => ['CarAds404ButtonText_2', '', 'string'],
        'button_2_link' => ['CarAds404ButtonLink_2', '', 'string'],
        'button_3_text' => ['CarAds404ButtonText_3', '', 'string'],
        'button_3_link' => ['CarAds404ButtonLink_3', '', 'string'],
        'button_4_text' => ['CarAds404ButtonText_4', '', 'string'],
        'button_4_link' => ['CarAds404ButtonLink_4', '', 'string'],
        'button_5_text' => ['CarAds404ButtonText_5', '', 'string'],
        'button_5_link' => ['CarAds404ButtonLink_5', '', 'string'],
        'button_6_text' => ['CarAds404ButtonText_6', '', 'string'],
        'button_6_link' => ['CarAds404ButtonLink_5', '', 'string'],

    ];

    public function __get($name){
        if(str_ends_with($name, '_default_value')){
            $base_name = substr($name, 0, -strlen('_default_value'));
            if(array_key_exists($base_name, $this->settings)){
                return $this->returnType($this->settings[$base_name][1], $this->settings[$base_name][2]);
            }
            throw new \InvalidArgumentException("Setting '$base_name' does not exist.");
        }

        if (str_ends_with($name, '_key')){
            $base_name = substr($name, 0, -strlen('_key'));
            if(array_key_exists($base_name, $this->settings)){
                return $this->settings[$base_name][0];
            }
            throw new \InvalidArgumentException("Setting '$base_name' does not exist.");
        }

        if(array_key_exists($name, $this->settings)){
            return $this->returnType(
                get_option($this->settings[$name][0], $this->settings[$name][1]),
                $this->settings[$name][2]
            );
        }

        throw new \InvalidArgumentException("Setting '$name' does not exist.");
    }

    private function returnType($value, $type) : mixed{
        return match ($type){
            'bool' => (bool) $value,
            'int' => (int) $value,
            'string' => (string) $value,
            'float' => (float) $value,
            default => $value
        };
    }


    public function __isset($name){
        return array_key_exists($name, $this->settings);
    }

    public function getCustomMessage(
        string $key,
        string $filename,
    ): string{
        $current_key = $this->{$key . '_key'};

        $custom_message = get_option("{$current_key}_{$filename}", '');
        if(!empty($custom_message)){
            return $custom_message;
        }

        return $this->{$key} ?? $this->{"{$key}_default_value"};
    }
}