<?php
/**
 * @copyright  Copyright (C) 2026 CarAds. All rights reserved.
 * @version 2026.01.20082526
 * @author CarAds Team
 */
namespace CarAds404\Wordpress;
use CarAds404\Basic\CustomizeHelper;
use CarAds404\Basic\Singleton;
use JetBrains\PhpStorm\NoReturn;
use WP_Customize_Manager;
use WP_Customize_Panel;
use WP_Customize_Section;
use function CarAds404\factory;

class Customize
{
    use Singleton{
        getInstance as public init;
    }

    private function __construct()
    {
        add_action('customize_register', [$this, 'register'], 1, 99);
    }

    #[NoReturn] public function register(WP_Customize_Manager $customize) : void{
        $panel = CustomizeHelper::panel(
            customize: $customize,
            key: 'carads_404_settings',
            title: __( 'CarAds 404', 'CarAds404' ),
        );

        $this->general($customize, $panel);
        $this->buttons($customize, $panel);
        $this->carads($customize, $panel);
        $this->carshop($customize, $panel);
    }

    private function buttons(WP_Customize_Manager $customize, $panel): void
    {
        $section = CustomizeHelper::Section(__( 'Buttons', 'CarAds404' ), $panel->id, $customize);
        for($i = 1; $i <= 6; $i++){
            CustomizeHelper::Text(
                customize: $customize,
                key: "CarAds404ButtonText_{$i}",
                label: __( '404 Knap tekst', 'CarAds404' ) . " #{$i}",
                default: '',
                section: $section->id,
                description: __('Indtast teksten, der skal vises på knappen.','CarAds404'),
            );
            CustomizeHelper::Text(
                customize: $customize,
                key: "CarAds404ButtonLink_{$i}",
                label: __( '404 Knap link', 'CarAds404' ) . " #{$i}",
                default: '',
                section: $section->id,
                description: __('Indtast linket, som knappen skal pege på.','CarAds404'),
            );
        }
    }

    private function general(WP_Customize_Manager $customize, $panel): void
    {
        $section = CustomizeHelper::Section(__( 'Beskeder', 'CarAds404' ), $panel->id, $customize);

        CustomizeHelper::Media(
            customize: $customize,
            key: 'CarAds404VideoURL',
            label: __( 'Upload video og brug den her.', 'CarAds404' ),
            section: $section->id,
            description: __('Tilfære video til systemet.', 'CarAds404'),
            mime_type: CustomizeHelper::MEDIA_MIME_VIDEO,
        );
        CustomizeHelper::Text(
            customize: $customize,
            key: 'CarAds404Heading',
            label: __( '404 Overskrift', 'CarAds404' ),
            default: factory()->settings->heading_default_value,
            section: $section->id,
            description: __('Indtast overskriften, der skal vises på 404-siden.', 'CarAds404'),
            sanitize_callback: CustomizeHelper::SANITIZE_EMPTY_STRING
        );
        CustomizeHelper::Textarea(
            customize: $customize,
            key: 'CarAds404Description',
            label: __( '404 Beskrivelse', 'CarAds404' ),
            default: factory()->settings->description_default_value,
            section: $section->id,
            description: __('Indtast beskrivelsen, der skal vises på 404-siden.', 'CarAds404'),
            sanitize_callback: CustomizeHelper::SANITIZE_EMPTY_STRING
        );
        CustomizeHelper::Checkbox(
            customize: $customize,
            key: 'CarAds404Simple404',
            label: __( 'Aktiver simpel 404-side', 'CarAds404' ),
            default: factory()->settings->simple_404_default_value,
            section: $section->id,
            description: __('Vil være mere simple 404 side end wordpress default - denne vil ikke indhold footer eller header - bare 404', 'CarAds404')
        );
        CustomizeHelper::Checkbox(
            customize: $customize,
            key: 'CarAds404Fast404',
            label: __( 'Hvis det 404 side, vil vi nu cache wp_header og wp_footer', 'CarAds404' ),
            default: factory()->settings->fast_404_default_value,
            section: $section->id,
            description: __('Hvis aktiveret, vil wp_header og wp_footer blive cached for at forbedre ydeevnen på 404-siden.', 'CarAds404')
        );
        CustomizeHelper::Textarea(
            customize: $customize,
            key: 'CarAds404AdditionalText',
            label: __( '404 Yderligere tekst', 'CarAds404' ),
            default: factory()->settings->additional_info_default_value,
            section: $section->id,
            description: __('Indtast yderligere tekst, der skal vises på 404-siden.','CarAds404'),
            sanitize_callback: CustomizeHelper::SANITIZE_EMPTY_STRING
        );

    }


    private function carshop(WP_Customize_Manager $customize, WP_Customize_Panel $panel) : void{
        if(factory()->carshop_exists){
            return;
        }

        $section = CustomizeHelper::Section(__( 'CarShop', 'CarAds404' ), $panel->id, $customize);


        CustomizeHelper::Checkbox(
            customize: $customize,
            key: 'CarAds404ShowCarsFromCarshop',
            label: __( 'Vis biler fra Carshop på 404-siden', 'CarAds404' ),
            default: factory()->settings->show_cars_from_carshop_default_value,
            section: $section->id,
            description: __('Hvis aktiveret, vises biler fra dit Carshop på 404-siden.', 'CarAds404')
        );
    }

    private function carads(WP_Customize_Manager $customize,  WP_Customize_Panel $panel) : void{
        if(!factory()->carads_exists){
            return;
        }

        $section = CustomizeHelper::Section(__( 'CarAds', 'CarAds404' ), $panel->id, $customize);

        CustomizeHelper::Checkbox(
            customize: $customize,
            key: 'CarAds404ShowCarsFromFeed',
            label: __( 'Vis biler fra feed på 404-siden', 'CarAds404' ),
            default: factory()->settings->show_cars_from_feed_default_value,
            section: $section->id,
            description: __('Hvis aktiveret, vises biler fra dit CarAds-feed på 404-siden.', 'CarAds404')
        );

        $files = [];
        if(CA_TEST){
            $files = glob(WP_CONTENT_DIR . '/plugins/carads/config/*_master_config.json');
        } else {
            $files = glob(WP_CONTENT_DIR . '/plugins/.c2/*_master_config.json');
        }

        $files = array_map(function(string $file){
            return basename($file, '_master_config.json');
        }, $files);

        if(empty($files)){
            return;
        }

        foreach($files as $file){
            CustomizeHelper::Text(
                customize: $customize,
                key: "CarAds404Heading_CarAds{$file}",
                label: __( '404 Overskrift', 'CarAds404') . " - " . ucfirst($file),
                default: factory()->settings->heading_default_value,
                section: $section->id,
                description: __('Indtast overskriften, der skal vises på 404-siden.', 'CarAds404'),
                sanitize_callback: CustomizeHelper::SANITIZE_EMPTY_STRING
            );
            CustomizeHelper::Textarea(
                customize: $customize,
                key: "CarAds404Description_CarAds{$file}",
                label: __( '404 Beskrivelse', 'CarAds404') . " - " . ucfirst($file),
                default: factory()->settings->description_default_value,
                section: $section->id,
                description: __('Indtast beskrivelsen, der skal vises på 404-siden.', 'CarAds404'),
                sanitize_callback: CustomizeHelper::SANITIZE_EMPTY_STRING
            );
            CustomizeHelper::Textarea(
                customize: $customize,
                key: "CarAds404AdditionalText_CarAds{$file}",
                label: __( '404 Yderligere tekst', 'CarAds404') . " - " . ucfirst($file),
                default: factory()->settings->additional_info_default_value,
                section: $section->id,
                description: __('Indtast yderligere tekst, der skal vises på 404-siden.','CarAds404'),
                sanitize_callback: CustomizeHelper::SANITIZE_EMPTY_STRING
            );
        }
    }
}