<?php
/**
 * @copyright  Copyright (C) 2026 CarAds. All rights reserved.
 * @version 2026.01.20082526
 * @author CarAds Team
 */
namespace CarAds404\Wordpress;

use CarAds404\Basic\Singleton;
use CarShop\Utils\Configs\Catalog;
use CarShop\Utils\Configs\Slider;
use CarShop\Utils\Enqueue as CarShopEnqueue;
use JetBrains\PhpStorm\NoReturn;
use function CarAds404\factory;
use function CarAds404\render;

class E404
{
    use Singleton{
        getInstance as public init;
    }

    private function __construct()
    {
        factory()->carads_exists &&
            add_action('template_redirect', [$this, 'carads'], 999, 0);
        factory()->carshop_exists &&
            add_action('template_redirect', [$this, 'carshop'], 999, 0);

        add_action('template_redirect', [$this, 'error'], 999, 0);
    }


    public function carshop(): void
    {
        if (!is_404()) {
            return;
        }

        $carshop_route = factory()->carshop_route;

        if(!$carshop_route || !$carshop_route->active()){
            return;
        }

        $active = $carshop_route->active();
        $slider = new \stdClass;
        $content = '';

        if(factory()->settings->show_cars_from_carshop){
            /** @var Catalog $config */
            $config = factory()->carshop_config->getCatalog($active->path);

            $slider = new Slider((object)[
                'cid' => $config->cid,
                'fid' => $config->fid ?? null,
                'filter' => $config->filter ?? null,
                'url' => ($active->base . '/'),
                'item_url' => ($active->base . '/%slug%-%id%'),
            ]);

            $configString = json_encode($slider);
            $content = render(CARSHOP_NEXTGEN_PATH . '/template-parts/slider_catalog.php', [
                'config' => $configString,
                'settings' => $slider,
                'id' => $config->cid,
                'trigger' => 1
            ]);

            CarShopEnqueue::css(CarShopEnqueue::SLIDER_CATALOG);
        }

        $this->render([
            'from' => 'carshop',
            'is_product' => $active->carshop === 'catalog-product',
            'show_cars_from_carshop' => factory()->settings->show_cars_from_carshop,
            'config' => $slider,
            'content' => $content,
        ]);
    }

    public function carads() : void
    {
        if (!is_404()) {
            return;
        }

        $carads_route = factory()->carads_route;

        if(!$carads_route || !$carads_route->active()){
            return;
        }

        $active = $carads_route->active();
        $config = new \stdClass;
        $content = '';

        if(factory()->settings->show_cars_from_feed){
            $config = \CarAdsNextgen\factory()->configs->get($active->path . '_master');

            $configString = json_encode($config);

            $content = render(CA_NEXTGEN_PATH . '/template-parts/shortcode/slider.php', [
                'config' => $configString,
                'settings' => $config,
                'id' => $config->cid,
                'trigger' => 1
            ]);
        }

        $namespace = $active->path ?
            "CarAds{$active->path}" :
            null;

        $settings = [
            'from' => 'carads',
            'is_product'            => $active->controller === 'product-detail',
            'show_cars_from_feed'   => factory()->settings->show_cars_from_feed,
            'config'                => $config,
            'content'               => $content,
        ];

        if($namespace){
            $settings['heading'] = factory()->settings->getCustomMessage(
                'heading',
                $namespace
            );
            $settings['description'] = factory()->settings->getCustomMessage(
                'description',
                $namespace
            );
            $settings['additional_info'] = factory()->settings->getCustomMessage(
                'additional_info',
                $namespace
            );
        }

        $this->render($settings);
    }

    public function error() : void{
        if(!is_404()){
            return;
        }

        $this->render([
            'from' => 'default',
            'is_product' => false,
        ]);
    }

    #[NoReturn] private function render(array $data) : void{

        $buttons = [];
        for($i = 1; $i <= 6; $i++){
            $text = factory()->settings->{"button_{$i}_text"};
            $link = factory()->settings->{"button_{$i}_link"};
            if(!empty($text) && !empty($link)){
                $buttons[$i] = [
                    'text' => $text,
                    'link' => $link,
                ];
            }
        }

        echo $this->header();

        echo render(CA404_NEXTGEN_PATH . '/template-parts/404.php', [
            'show_cars_from_carshop' => false,
            'show_cars_from_feed' => false,
            'content' => '',
            'video_url' => factory()->settings->video_url,
            'heading' => factory()->settings->heading,
            'description' => factory()->settings->description,
            'additional_info' => factory()->settings->additional_info,
            'buttons' => $buttons,
            ...$data,
        ]);
        echo $this->footer();
        die;
    }

    private function header() :string{
        return $this->cache(
            '404-header.html',
            3600,
            function (){
                if(factory()->settings->simple_404){
                    echo render(CA404_NEXTGEN_PATH . '/template-parts/simple_header.php', []);
                    return;
                }

                get_header();
            }
        );
    }
    private function footer(): string
    {
        return $this->cache(
            '404-footer.html',
            3600,
            function (){
                if(factory()->settings->simple_404){
                    echo render(CA404_NEXTGEN_PATH . '/template-parts/simple_footer.php', []);
                    return;
                }

                get_footer();
            }
        );
    }

    private function cache(string $fileName, int $duration, callable $callback) : string{
        if(factory()->settings->fast_404 && !is_user_logged_in()){
            // create cache folder if not exists
            $cacheDir = WP_CONTENT_DIR . '/carads404-cache/';
            if (!file_exists($cacheDir)) {
                mkdir($cacheDir, 0755, true);
            }
            $cacheFile = $cacheDir . $fileName;
            if (file_exists($cacheFile) && (time() - filemtime($cacheFile) < $duration)) {
                return file_get_contents($cacheFile);
            }

            $output = $this->captureOutput($callback);
            file_put_contents($cacheFile, $output);
            return $output;
        }

        return $this->captureOutput($callback);
    }

    private function captureOutput(callable $callback) : string{
        ob_start();
        $callback();
        return ob_get_clean();
    }
}