<?php
/**
 * @var string $from
 * @var bool $is_product
 * @var int $video_url
 * @var string $heading
 * @var string $description
 * @var string $additional_info
 * @var bool $show_cars_from_carshop
 * @var bool $show_cars_from_feed
 * @var array $buttons
 *
 * @var object|null $config
 * @var string|null $content
 */

if(!defined('ABSPATH')){
    exit;
}
?>
<div id="carads-404-easy_wrapper">
    <section id="carads-404-easy">
        <div>
            <video
                    class="elementor-background-video-hosted"
                    autoplay="" muted="" playsinline="" loop=""
                    src="<?php echo $video_url ? wp_get_attachment_url($video_url) : (CA404_URL . 'assets/404.mp4'); ?>"
                    style="width: 100%; height: auto;"
            ></video>
        </div>
        <div>
            <h2><?php echo $heading; ?></h2>
            <p><?php echo $description; ?></p>
            <p>
                <?php echo $additional_info; ?>
            </p>
            <div class="buttons-wrapper">
                <?php foreach($buttons as $button): ?>
                    <a class="elementor-button elementor-button-link elementor-size-sm" href="<?php echo esc_url($button['link']); ?>">
                        <span class="elementor-button-content-wrapper">
                            <span class="elementor-button-text"><?php echo esc_html($button['text']); ?></span>
                        </span>
                    </a>
                <?php endforeach; ?>
            </div>
        </div>
    </section>
    <?php if($show_cars_from_carshop): ?>
        <?php echo $content; ?>
    <?php endif; ?>
    <?php if($show_cars_from_feed): ?>
        <?php echo $content; ?>
    <?php endif; ?>
</div>
<style>
    #carads-404-easy_wrapper{
        margin: var(--ca404-wrapper-margin, 100px auto);
        padding: var(--ca404-wrapper-padding, 50px);
        max-width: var(--ca404-wrapper-max-width, 1220px);
    }
    #carads-404-easy{
        display: flex;
        gap: 20px;
    }
    #carads-404-easy > div{
        display: flex;
        flex-direction: column;
        justify-content: center;
    }
    #carads-404-easy > div:first-child{
        background-color: var(--ca404-video-bg, transparent);
        width: var(--ca404-video-width, 50%);
    }
    #carads-404-easy > div:last-child{
        width: var(--ca404-text-width, 50%);
        gap: 20px;
    }
    #carads-404-easy .buttons-wrapper{
        display: grid;
        grid-template-columns: var(--ca404-buttons-grid-template-columns, repeat(3, 1fr));
        gap: var(--ca404-buttons-gap, 10px);
        direction: var(--ca404-buttons-wrapper, ltr);
    }
</style>