<?php
/*************************
 * Plugin Name: CarAds Auth NextGen
 * Description: Login og registration system for CarAds NextGen websites. - carads.io
 * Plugin URI: https://carads.io/
 * Version: 2026.01.20082523
 * Requires at least: 6.9
 * Requires PHP: 8.3
 * Author: carads.io
 * Author URI: https://carads.io/
 * Text Domain: carads-auth-nextgen
 *************************/
include_once __DIR__ . '/includes/_register.php';
defined('ABSPATH') or die('');

#ini_set('display_errors', 1);
#ini_set('display_startup_errors', 1);
#error_reporting(E_ALL);

const CA_AUTH_NEXTGEN_PATH = __DIR__;
const CA_AUTH_NEXTGEN_FILE = __FILE__;

define("CA_AUTH_NEXTGEN_URL", plugin_dir_url(__FILE__));
define("CA_AUTH_NEXTGEN_BASE", plugin_basename(__FILE__));
define("CA_AUTH_TEST", (function_exists('getenv_docker') ? getenv_docker('CA_TEST', 'false') : 'false') === 'true');
define("CA_AUTH_TIME", 1768897523);
const CA_AUTH_NEXTGEN_VERSION = '2026.01.20082523';
const CA_AUTH_BRANCH = 'develop';
const CA_AUTH_PHP_VERSION = '8.3';

const CA_AUTH_WORDPRESS_VERSION = '6.9';

add_action( 'plugins_loaded', function() {
    include_once ABSPATH . 'wp-includes/pluggable.php';

    \CarAdsAuth\Utils\Wordpress::init();
    \CarAdsAuth\User\Authenticate::init();
    \CarAdsAuth\User\Capabilities::init();
    \CarAdsAuth\User\Edit::init();
});