<?php
/**
 * @copyright  Copyright (C) 2026 CarAds. All rights reserved.
 * @version 2026.01.20082523
 * @author CarAds Team
 */
namespace CarAdsAuth\User;
use CarAdsAuth\Utils\Singleton;
use stdClass;
use WP_Error;
use function CarAdsAuth\isCarAdsUser;

class Edit
{
    use Singleton {
        getInstance as public init;
    }

    private bool $tried_change_email = false;
    private bool $tried_change_password = false;

    private function __construct()
    {
        add_filter('wp_pre_insert_user_data', [$this, 'pre_insert_user_data'], 999, 4);
        add_filter('user_profile_update_errors', [$this, 'user_profile_update_errors'], 999, 3);
        add_filter('personal_options_update', [$this, 'proxy_personal_options_update'], 1);
        add_filter('edit_user_profile_update', [$this, 'proxy_edit_user_profile_update'], 1);


        #add_filter('personal_options_update',  [$this, 'notAllowedToUpdate'], 1);
       # add_filter('edit_user_profile_update',  [$this, 'notAllowedToUpdate'], 1);
        // wp_insert_user:
        // wp_pre_insert_user_data - run before inserting user data - as i, can see it - we can change data before insert
        // insert_user_meta - here is meta data added and i think we can change user rules from here
        // insert_custom_user_meta - after meta data is added
        // insert user meta and custom user meta are merge to one array.
        // profile_update - after user is updated - if users is create so it user_register.


        // wp_update_user:
        // send_password_change_email
        // send_email_change_email
        // and call after wp_insert_user
    }

    public function proxy_personal_options_update(int $user_id) : void{
        $current_user = wp_get_current_user();

        if(!is_a($current_user, 'WP_User')){
            return;
        }

        if($current_user->ID === $user_id && isCarAdsUser($current_user->user_email)){
            // check if email is changed
            if(isset($_POST['email']) && $_POST['email'] !== $current_user->user_email){
                $_POST['email'] = $current_user->user_email;
                $this->tried_change_email = true;
            }


        }
    }

    public function proxy_edit_user_profile_update(int $user_id) : void{
        $user = get_user_by('id', $user_id);

        if(!is_a($user, 'WP_User')){
            return;
        }

        // if $user is carads user and try to change password or email - block it
        if(isCarAdsUser($user->user_email)){
            // check if email is changed
            if(isset($_POST['email']) && $_POST['email'] !== $user->user_email){
                $_POST['email'] = $user->user_email;
                $this->tried_change_email = true;
            }

            if($_POST['pass1'] !== '' || $_POST['pass2'] !== ''){
                $_POST['pass1'] = '';
                $_POST['pass2'] = '';
                $this->tried_change_password = true;
            }
        }

    }

    public function user_profile_update_errors(WP_Error $errors, $update, stdClass $user): void
    {
        if(!$update){
            return;
        }

        $current_user = get_user_by('id', $user->ID);

        if(!is_a($current_user, 'WP_User')){
            return;
        }

        if(!isCarAdsUser($current_user->user_email)){
            return;
        }

        if(isset($_POST['email']) && ($_POST['email'] !== $current_user->user_email || $this->tried_change_email)){
            $errors->add('invalid_email', 'email is not allowed to update carads user email', array(
                'form-field' => 'email',
            ));
        }

        if($this->tried_change_password){
            $errors->add('invalid_password', 'password is not allowed to update carads user password', array(
                'form-field' => 'pass1',
            ));
        }
    }

    public function pre_insert_user_data(array $user, bool $updated, ?int $user_id, array $raw) : array{
        if(!$updated){
            return $user;
        }

        // only for existing users
        $oldUser = get_user_by('id', $user_id);

        if (!is_a($oldUser, 'WP_User')){
            return $user;
        }

        if(isCarAdsUser($oldUser->user_email)){
            $user['display_name']   = $oldUser->display_name;
            $user['user_pass']      = wp_generate_password(256, true);
            $user['user_email']     = $oldUser->user_email;
        }

        return $user;
    }
}