<?php
/**
 * @copyright  Copyright (C) 2026 CarAds. All rights reserved.
 * @version 2026.01.20082523
 * @author CarAds Team
 */
namespace CarAdsAuth\Utils;

use Exception;

trait Singleton
{
    /**
     * @var self
     */
    protected static $instance = null;

    /**
     * @return self
     */
    public static function getInstance() : self
    {
        return static::$instance ?? (self::$instance = new static);
    }
}